/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.oomph.p2.internal.core.AgentAnalyzer;
import org.eclipse.oomph.p2.internal.ui.AgentAnalyzerComposite;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdditionalURIPrompterDialog
extends OomphDialog
implements ICheckStateListener {
    private final Set<URI> checkedRepositories = new HashSet<URI>();
    private boolean firstTime;
    private List<AgentAnalyzer.AnalyzedArtifact> artifacts;
    private Set<URI> repositories;
    private CheckboxTableViewer repositoryViewer;

    public AdditionalURIPrompterDialog(Shell parentShell, boolean firstTime, List<AgentAnalyzer.AnalyzedArtifact> artifacts, Set<URI> repositories) {
        super(parentShell, "Bundle Pool Analysis", 600, 500, (OomphUIPlugin)P2UIPlugin.INSTANCE, false);
        this.setShellStyle(68656);
        this.firstTime = firstTime;
        this.artifacts = artifacts;
        this.repositories = repositories;
    }

    public Set<URI> getCheckedRepositories() {
        return this.checkedRepositories;
    }

    protected String getShellText() {
        return "Bundle Pool Analysis";
    }

    protected String getDefaultMessage() {
        return "Some artifacts could not be downloaded from the " + (this.firstTime ? "repositories listed in the profiles" : "previously checked repositories") + ".\n" + "Please check additional repositories and try again.";
    }

    protected String getImagePath() {
        return "wizban/AgentAnalyzer.png";
    }

    protected void createUI(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(1808));
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginWidth = 10;
        mainLayout.marginHeight = 10;
        mainComposite.setLayout((Layout)mainLayout);
        SashForm sashForm = new SashForm(mainComposite, 66048);
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite artifactComposite = new Composite((Composite)sashForm, 0);
        GridLayout artifactLayout = new GridLayout();
        artifactLayout.marginWidth = 0;
        artifactLayout.marginHeight = 0;
        artifactComposite.setLayout((Layout)artifactLayout);
        Label artifactLabel = new Label(artifactComposite, 0);
        artifactLabel.setText("Remaining Damaged Artifacts:");
        TableViewer artifactViewer = new TableViewer(artifactComposite, 67584);
        artifactViewer.getTable().setLayoutData((Object)new GridData(1808));
        artifactViewer.setSorter(new ViewerSorter());
        artifactViewer.setLabelProvider((IBaseLabelProvider)new AgentAnalyzerComposite.TableLabelProvider(parent.getDisplay(), true));
        artifactViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        artifactViewer.setInput(this.artifacts);
        Composite repositoryComposite = new Composite((Composite)sashForm, 0);
        GridLayout repositoryLayout = new GridLayout();
        repositoryLayout.marginTop = 10;
        repositoryLayout.marginWidth = 0;
        repositoryLayout.marginHeight = 0;
        repositoryComposite.setLayout((Layout)repositoryLayout);
        Composite repositoryHeader = new Composite(repositoryComposite, 0);
        repositoryHeader.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout repositoryHeaderLayout = new GridLayout(2, false);
        repositoryHeaderLayout.marginWidth = 0;
        repositoryHeaderLayout.marginHeight = 0;
        repositoryHeader.setLayout((Layout)repositoryHeaderLayout);
        Label repositoryLabel = new Label(repositoryHeader, 0);
        repositoryLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        repositoryLabel.setText("Additional Repositories:");
        ToolBar toolBar = new ToolBar(repositoryHeader, 0x820000);
        toolBar.setBounds(0, 0, 89, 23);
        ToolItem checkAll = new ToolItem(toolBar, 0);
        checkAll.setToolTipText("Check all repositories");
        checkAll.setImage(this.getDefaultImage("tool16/checkAll"));
        ToolItem uncheckAll = new ToolItem(toolBar, 0);
        uncheckAll.setToolTipText("Uncheck all repositories");
        uncheckAll.setImage(this.getDefaultImage("tool16/uncheckAll"));
        this.repositoryViewer = CheckboxTableViewer.newCheckList((Composite)repositoryComposite, (int)67584);
        this.repositoryViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.repositoryViewer.setSorter(new ViewerSorter());
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new AgentAnalyzerComposite.TableLabelProvider(parent.getDisplay()));
        this.repositoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repositoryViewer.setInput(this.repositories);
        this.repositoryViewer.addCheckStateListener((ICheckStateListener)this);
        checkAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalURIPrompterDialog.this.repositoryViewer.setAllChecked(true);
                AdditionalURIPrompterDialog.this.checkStateChanged(null);
            }
        });
        uncheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalURIPrompterDialog.this.repositoryViewer.setAllChecked(false);
                AdditionalURIPrompterDialog.this.checkStateChanged(null);
            }
        });
        Composite uriComposite = new Composite(repositoryComposite, 0);
        GridLayout uriLayout = new GridLayout(3, false);
        uriLayout.marginWidth = 0;
        uriLayout.marginHeight = 0;
        uriComposite.setLayout((Layout)uriLayout);
        uriComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label uriLabel = new Label(uriComposite, 0);
        uriLabel.setText("URI:");
        final AtomicReference enteredURI = new AtomicReference();
        final Text uriText = new Text(uriComposite, 2048);
        uriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button uriButton = new Button(uriComposite, 0);
        uriButton.setText("Add");
        uriButton.setToolTipText("Add the entered URI to the repositories list");
        uriButton.setEnabled(false);
        uriButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI uri = (URI)enteredURI.get();
                AdditionalURIPrompterDialog.this.repositories.add(uri);
                AdditionalURIPrompterDialog.this.repositoryViewer.refresh();
                AdditionalURIPrompterDialog.this.repositoryViewer.setChecked((Object)uri, true);
                AdditionalURIPrompterDialog.this.checkStateChanged(null);
                uriText.setText("");
                uriText.setFocus();
            }
        });
        uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                URI uri;
                try {
                    String text = uriText.getText();
                    uri = text.length() == 0 ? null : new URI(text);
                }
                catch (Exception exception) {
                    uri = null;
                }
                enteredURI.set(uri);
                uriButton.setEnabled(uri != null);
            }
        });
        sashForm.setWeights(new int[]{1, 2});
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkStateChanged(null);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.checkedRepositories.clear();
        Object[] objectArray = this.repositoryViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.checkedRepositories.add((URI)object);
            ++n2;
        }
        this.getButton(0).setEnabled(!this.checkedRepositories.isEmpty());
    }
}

