/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum R4EReviewType implements Enumerator
{
    R4E_REVIEW_TYPE_BASIC(0, "R4E_REVIEW_TYPE_BASIC", "R4E_REVIEW_TYPE_BASIC"),
    R4E_REVIEW_TYPE_INFORMAL(1, "R4E_REVIEW_TYPE_INFORMAL", "R4E_REVIEW_TYPE_INFORMAL"),
    R4E_REVIEW_TYPE_FORMAL(2, "R4E_REVIEW_TYPE_FORMAL", "R4E_REVIEW_TYPE_FORMAL");

    public static final int R4E_REVIEW_TYPE_BASIC_VALUE = 0;
    public static final int R4E_REVIEW_TYPE_INFORMAL_VALUE = 1;
    public static final int R4E_REVIEW_TYPE_FORMAL_VALUE = 2;
    private static final R4EReviewType[] VALUES_ARRAY;
    public static final List<R4EReviewType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new R4EReviewType[]{R4E_REVIEW_TYPE_BASIC, R4E_REVIEW_TYPE_INFORMAL, R4E_REVIEW_TYPE_FORMAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static R4EReviewType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            R4EReviewType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static R4EReviewType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            R4EReviewType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static R4EReviewType get(int value) {
        switch (value) {
            case 0: {
                return R4E_REVIEW_TYPE_BASIC;
            }
            case 1: {
                return R4E_REVIEW_TYPE_INFORMAL;
            }
            case 2: {
                return R4E_REVIEW_TYPE_FORMAL;
            }
        }
        return null;
    }

    private R4EReviewType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

