/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocumentScore;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchIndex;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.SearchQuery;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;

@Deprecated
public class ElasticsearchQuery
implements SearchQuery {
    private final SearchRequestBuilder request;
    private final QueryBuilder qb;
    private ElasticsearchIndex index;

    public ElasticsearchQuery(SearchRequestBuilder request, QueryBuilder qb, ElasticsearchIndex index) {
        this.request = request;
        this.qb = qb;
        this.index = index;
    }

    @Override
    public Iterable<? extends DocumentScore> query(Resource resource) throws IOException {
        SearchHits hits = resource != null ? this.index.search(resource, this.request, this.qb) : this.index.search(this.request, this.qb);
        return Iterables.transform((Iterable)hits, (Function)new Function<SearchHit, DocumentScore>(){

            public DocumentScore apply(SearchHit hit) {
                return new ElasticsearchDocumentScore(hit, null);
            }
        });
    }

    @Override
    public void highlight(IRI property) {
        String field = property != null ? ElasticsearchIndex.toPropertyFieldName(SearchFields.getPropertyField(property)) : "p_*";
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(field);
        hb.preTags(new String[]{"<B>"});
        hb.postTags(new String[]{"</B>"});
        hb.numOfFragments(Integer.valueOf(0));
        this.request.highlighter(hb);
    }
}

