/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class DatatypeFilter
extends FilterPlanNode {
    private final Resource datatype;
    private StackTraceElement[] stackTrace;

    public DatatypeFilter(PlanNode parent, Resource datatype) {
        super(parent);
        this.datatype = datatype;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        if (!t.getValue().isLiteral()) {
            return false;
        }
        Literal literal = (Literal)t.getValue();
        return literal.getDatatype() == this.datatype || literal.getDatatype().equals(this.datatype);
    }

    @Override
    public String toString() {
        return "DatatypeFilter{datatype=" + Formatter.prefix(this.datatype) + '}';
    }
}

