/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lucene.LuceneSailSchema;
import org.eclipse.rdf4j.sail.lucene.QuerySpec;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySpecBuilder
implements SearchQueryInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(QuerySpecBuilder.class);
    private final boolean incompleteQueryFails;
    private final IRI indexId;

    public QuerySpecBuilder(boolean incompleteQueryFails) {
        this(incompleteQueryFails, null);
    }

    public QuerySpecBuilder(boolean incompleteQueryFails, IRI indexId) {
        this.incompleteQueryFails = incompleteQueryFails;
        this.indexId = indexId;
    }

    @Deprecated
    public Set<QuerySpec> process(TupleExpr tupleExpr, BindingSet bindings) throws SailException {
        HashSet<SearchQueryEvaluator> result = new HashSet<SearchQueryEvaluator>();
        this.process(tupleExpr, bindings, result);
        return result;
    }

    @Override
    public void process(TupleExpr tupleExpr, BindingSet bindings, Collection<SearchQueryEvaluator> result) throws SailException {
        PatternFilter filter = new PatternFilter();
        tupleExpr.visit((QueryModelVisitor)filter);
        for (StatementPattern matchesPattern : filter.matchesPatterns) {
            QuerySpec querySpec;
            Var snippetVar;
            Var scoreVar;
            StatementPattern snippetPattern;
            StatementPattern scorePattern;
            StatementPattern propertyPattern;
            List<StatementPattern> queryPatterns;
            StatementPattern typePattern;
            StatementPattern idPattern;
            Value subjectValue;
            Var subjectVar = matchesPattern.getSubjectVar();
            Value value = subjectValue = subjectVar.hasValue() ? subjectVar.getValue() : bindings.getValue(subjectVar.getName());
            if (subjectValue != null && !(subjectValue instanceof Resource)) {
                this.failOrWarn(LuceneSailSchema.MATCHES + " properties should have Resource subjects: " + subjectVar.getValue());
                continue;
            }
            Resource subject = (Resource)subjectValue;
            Var matchesVar = matchesPattern.getObjectVar();
            if (matchesVar.hasValue()) {
                this.failOrWarn(LuceneSailSchema.MATCHES + " properties should have variable objects: " + matchesVar.getValue());
                continue;
            }
            if (this.indexId != null) {
                Var indexIdVar;
                Value indexIdValue;
                try {
                    idPattern = this.getPattern(matchesVar, filter.idPatterns);
                }
                catch (IllegalArgumentException e) {
                    this.failOrWarn(e);
                    continue;
                }
                if (idPattern == null || !((indexIdValue = (indexIdVar = idPattern.getObjectVar()).hasValue() ? indexIdVar.getValue() : bindings.getValue(indexIdVar.getName())) instanceof IRI) || !indexIdVar.getValue().equals(this.indexId)) {
                    continue;
                }
            } else {
                idPattern = null;
            }
            try {
                typePattern = this.getPattern(matchesVar, filter.typePatterns);
                queryPatterns = this.getQueryVar(matchesVar, filter.queryPatterns);
                propertyPattern = this.getPattern(matchesVar, filter.propertyPatterns);
                scorePattern = this.getPattern(matchesVar, filter.scorePatterns);
                snippetPattern = this.getPattern(matchesVar, filter.snippetPatterns);
            }
            catch (IllegalArgumentException e) {
                this.failOrWarn(e);
                continue;
            }
            String queryString = null;
            ArrayList<QuerySpec.QueryParam> queries = new ArrayList<QuerySpec.QueryParam>();
            StatementPattern litQueryPattern = null;
            boolean multiFieldQuery = false;
            if (!queryPatterns.isEmpty()) {
                Var queryVar = queryPatterns.get(0).getObjectVar();
                Value firstQueryValue = queryVar.hasValue() ? queryVar.getValue() : bindings.getValue(queryVar.getName());
                boolean bl = multiFieldQuery = firstQueryValue == null || !firstQueryValue.isLiteral();
                if (multiFieldQuery) {
                    for (StatementPattern queryPattern : queryPatterns) {
                        Var snippetVar2;
                        Var queryPatternVar = queryPattern.getObjectVar();
                        StatementPattern fieldQueryQueryPattern = this.getPattern(queryPatternVar, filter.queryPatterns);
                        StatementPattern fieldQueryBoostPattern = this.getPattern(queryPatternVar, filter.boostPatterns);
                        StatementPattern fieldQueryPropertyPattern = this.getPattern(queryPatternVar, filter.propertyPatterns);
                        StatementPattern fieldQuerySnippetPattern = this.getPattern(queryPatternVar, filter.snippetPatterns);
                        StatementPattern fieldTypePattern = this.getPattern(queryPatternVar, filter.typePatterns);
                        String query = null;
                        IRI property = null;
                        Float boost = null;
                        Var var = snippetVar2 = fieldQuerySnippetPattern == null ? null : fieldQuerySnippetPattern.getObjectVar();
                        if (fieldQueryQueryPattern != null) {
                            Value queryValue;
                            Var fieldQueryQueryVar = fieldQueryQueryPattern.getObjectVar();
                            Value value2 = queryValue = fieldQueryQueryVar.hasValue() ? fieldQueryQueryVar.getValue() : bindings.getValue(fieldQueryQueryVar.getName());
                            if (queryValue instanceof Literal) {
                                query = ((Literal)queryValue).getLabel();
                            }
                        }
                        if (fieldQueryBoostPattern != null) {
                            Value boostValue;
                            Var fieldQueryBoostVar = fieldQueryBoostPattern.getObjectVar();
                            Value value3 = boostValue = fieldQueryBoostVar.hasValue() ? fieldQueryBoostVar.getValue() : bindings.getValue(fieldQueryBoostVar.getName());
                            if (boostValue instanceof Literal) {
                                boost = Float.valueOf(((Literal)boostValue).floatValue());
                            }
                        }
                        if (fieldQueryPropertyPattern != null) {
                            Value propertyValue;
                            Var propertyVar = fieldQueryPropertyPattern.getObjectVar();
                            Value value4 = propertyValue = propertyVar.hasValue() ? propertyVar.getValue() : bindings.getValue(propertyVar.getName());
                            if (propertyValue instanceof IRI) {
                                property = (IRI)propertyValue;
                            } else if (propertyValue != null) {
                                this.failOrWarn(LuceneSailSchema.PROPERTY + " should have a property URI or a variable as object: " + propertyVar.getValue());
                                continue;
                            }
                        }
                        if (snippetVar2 != null && snippetVar2.hasValue()) {
                            this.failOrWarn(LuceneSailSchema.SNIPPET + " should have a variable as object: " + snippetVar2.getValue());
                            continue;
                        }
                        if (fieldTypePattern == null) {
                            logger.debug("Query variable '{}' has not rdf:type, assuming {}", (Object)fieldTypePattern, (Object)LuceneSailSchema.LUCENE_QUERY);
                        }
                        queries.add(new QuerySpec.QueryParam(queryPattern, fieldQueryQueryPattern, fieldQueryPropertyPattern, fieldQuerySnippetPattern, fieldQueryBoostPattern, fieldTypePattern, query, property, boost));
                    }
                } else {
                    queryString = ((Literal)firstQueryValue).getLabel();
                    litQueryPattern = queryPatterns.get(0);
                }
            }
            IRI propertyURI = null;
            if (propertyPattern != null) {
                Value propertyValue;
                if (multiFieldQuery) {
                    this.failOrWarn(LuceneSailSchema.PROPERTY + " can't be used with " + LuceneSailSchema.MATCHES + " for non literal query");
                    continue;
                }
                Var propertyVar = propertyPattern.getObjectVar();
                Value value5 = propertyValue = propertyVar.hasValue() ? propertyVar.getValue() : bindings.getValue(propertyVar.getName());
                if (propertyValue instanceof IRI) {
                    propertyURI = (IRI)propertyValue;
                } else if (propertyValue != null) {
                    this.failOrWarn(LuceneSailSchema.PROPERTY + " should have a property URI or a variable as object: " + propertyVar.getValue());
                    continue;
                }
            }
            Var var = scoreVar = scorePattern == null ? null : scorePattern.getObjectVar();
            if (scoreVar != null && scoreVar.hasValue()) {
                this.failOrWarn(LuceneSailSchema.SCORE + " should have a variable as object: " + scoreVar.getValue());
                continue;
            }
            Var var2 = snippetVar = snippetPattern == null ? null : snippetPattern.getObjectVar();
            if (snippetVar != null && snippetVar.hasValue()) {
                this.failOrWarn(LuceneSailSchema.SNIPPET + " should have a variable as object: " + snippetVar.getValue());
                continue;
            }
            if (typePattern == null) {
                logger.debug("Query variable '{}' has not rdf:type, assuming {}", (Object)subject, (Object)LuceneSailSchema.LUCENE_QUERY);
            }
            if (!multiFieldQuery) {
                queries.add(new QuerySpec.QueryParam(litQueryPattern, propertyPattern, snippetPattern, null, queryString, propertyURI, null));
            }
            if ((querySpec = new QuerySpec(matchesPattern, queries, scorePattern, typePattern, idPattern, subject)).isEvaluable()) {
                result.add(querySpec);
                continue;
            }
            TupleFunctionCall funcCall = new TupleFunctionCall();
            funcCall.setURI(LuceneSailSchema.SEARCH.toString());
            if (multiFieldQuery) {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.QUERY));
                funcCall.addArg((ValueExpr)new ValueConstant((Value)Values.literal((int)queryPatterns.size())));
                queryPatterns.stream().map(StatementPattern::getObjectVar).forEach(arg_0 -> ((TupleFunctionCall)funcCall).addArg(arg_0));
            } else {
                funcCall.addArg((ValueExpr)queryPatterns.get(0).getObjectVar());
            }
            if (subject != null) {
                funcCall.addArg((ValueExpr)matchesPattern.getSubjectVar());
            } else {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.ALL_MATCHES));
                funcCall.addResultVar(matchesPattern.getSubjectVar());
            }
            if (propertyPattern != null) {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.PROPERTY));
                if (propertyURI != null) {
                    funcCall.addArg((ValueExpr)propertyPattern.getObjectVar());
                } else {
                    funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.ALL_PROPERTIES));
                    funcCall.addResultVar(propertyPattern.getObjectVar());
                }
            }
            if (scoreVar != null) {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.SCORE));
                funcCall.addResultVar(scoreVar);
            }
            if (snippetVar != null) {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.SNIPPET));
                funcCall.addResultVar(snippetVar);
            }
            Join join = new Join();
            matchesPattern.replaceWith((QueryModelNode)join);
            join.setLeftArg((TupleExpr)matchesPattern);
            join.setRightArg((TupleExpr)funcCall);
            querySpec.removeQueryPatterns();
        }
    }

    private void failOrWarn(Exception exception) throws SailException {
        if (this.incompleteQueryFails) {
            throw exception instanceof SailException ? (SailException)exception : new SailException((Throwable)exception);
        }
        logger.warn(exception.getMessage(), (Throwable)exception);
    }

    private void failOrWarn(String message) throws SailException {
        if (this.incompleteQueryFails) {
            throw new SailException("Invalid Text Query: " + message);
        }
        logger.warn(message);
    }

    private StatementPattern getPattern(Var subjectVar, ArrayList<StatementPattern> patterns) throws IllegalArgumentException {
        StatementPattern result = null;
        for (StatementPattern pattern : patterns) {
            if (!pattern.getSubjectVar().equals((Object)subjectVar)) continue;
            if (result == null) {
                result = pattern;
                continue;
            }
            throw new IllegalArgumentException("multiple StatementPatterns with the same subject: " + result + ", " + pattern);
        }
        if (result != null) {
            patterns.remove(result);
        }
        return result;
    }

    private List<StatementPattern> getQueryVar(Var subjectVar, ArrayList<StatementPattern> patterns) throws IllegalArgumentException {
        StatementPattern litResult = null;
        ArrayList<StatementPattern> objectResult = null;
        for (StatementPattern pattern : patterns) {
            if (!pattern.getSubjectVar().equals((Object)subjectVar)) continue;
            Var queryPatternVar = pattern.getObjectVar();
            if (queryPatternVar.hasValue() && queryPatternVar.getValue().isLiteral()) {
                if (objectResult != null) {
                    throw new IllegalArgumentException("query can't be done over both literal and resource!");
                }
                if (litResult != null) {
                    throw new IllegalArgumentException("multiple StatementPatterns with the same subject: " + litResult + ", " + pattern);
                }
                litResult = pattern;
                continue;
            }
            if (litResult != null) {
                throw new IllegalArgumentException("query can't be done over both literal and resource!");
            }
            if (objectResult == null) {
                objectResult = new ArrayList<StatementPattern>();
            }
            objectResult.add(pattern);
        }
        if (litResult != null) {
            patterns.remove(litResult);
            return List.of(litResult);
        }
        if (objectResult != null) {
            patterns.removeAll(objectResult);
            return objectResult;
        }
        return List.of();
    }

    private static class PatternFilter
    extends AbstractQueryModelVisitor<RuntimeException> {
        public ArrayList<StatementPattern> typePatterns = new ArrayList();
        public ArrayList<StatementPattern> matchesPatterns = new ArrayList();
        public ArrayList<StatementPattern> queryPatterns = new ArrayList();
        public ArrayList<StatementPattern> propertyPatterns = new ArrayList();
        public ArrayList<StatementPattern> scorePatterns = new ArrayList();
        public ArrayList<StatementPattern> snippetPatterns = new ArrayList();
        public ArrayList<StatementPattern> idPatterns = new ArrayList();
        public ArrayList<StatementPattern> boostPatterns = new ArrayList();

        private PatternFilter() {
        }

        public void meet(StatementPattern node) {
            Value object;
            Value predicate = node.getPredicateVar().getValue();
            if (LuceneSailSchema.MATCHES.equals((Object)predicate)) {
                this.matchesPatterns.add(node);
            } else if (LuceneSailSchema.QUERY.equals((Object)predicate)) {
                this.queryPatterns.add(node);
            } else if (LuceneSailSchema.PROPERTY.equals((Object)predicate)) {
                this.propertyPatterns.add(node);
            } else if (LuceneSailSchema.SCORE.equals((Object)predicate)) {
                this.scorePatterns.add(node);
            } else if (LuceneSailSchema.SNIPPET.equals((Object)predicate)) {
                this.snippetPatterns.add(node);
            } else if (LuceneSailSchema.INDEXID.equals((Object)predicate)) {
                this.idPatterns.add(node);
            } else if (LuceneSailSchema.BOOST.equals((Object)predicate)) {
                this.boostPatterns.add(node);
            } else if (RDF.TYPE.equals((Object)predicate) && LuceneSailSchema.LUCENE_QUERY.equals((Object)(object = node.getObjectVar().getValue()))) {
                this.typePatterns.add(node);
            }
        }
    }
}

