/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.document;

import java.io.InputStream;
import java.io.Reader;
import java.util.stream.Collectors;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.document.JsonDocument;
import no.hasmac.jsonld.document.RdfDocument;
import no.hasmac.jsonld.http.media.MediaType;
import no.hasmac.rdf.Rdf;

@Deprecated(since="1.0.4")
public final class DocumentParser {
    private DocumentParser() {
    }

    public static Document parse(MediaType contentType, InputStream inputStream) throws JsonLdError {
        if (inputStream == null) {
            throw new IllegalArgumentException("The provided content InputStream is null.");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("The provided content type is null.");
        }
        if (JsonDocument.accepts(contentType)) {
            return JsonDocument.of(contentType, inputStream);
        }
        if (RdfDocument.accepts(contentType)) {
            return RdfDocument.of(contentType, inputStream);
        }
        throw DocumentParser.unsupportedMediaType(contentType);
    }

    public static Document parse(MediaType contentType, Reader reader) throws JsonLdError {
        if (reader == null) {
            throw new IllegalArgumentException("The provided content reader is null.");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("The provided content type is null.");
        }
        if (JsonDocument.accepts(contentType)) {
            return JsonDocument.of(contentType, reader);
        }
        if (RdfDocument.accepts(contentType)) {
            return RdfDocument.of(contentType, reader);
        }
        throw DocumentParser.unsupportedMediaType(contentType);
    }

    private static JsonLdError unsupportedMediaType(MediaType contentType) throws JsonLdError {
        return new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported media type '" + String.valueOf(contentType) + "'. Supported content types are [" + String.valueOf(MediaType.JSON_LD) + ", " + String.valueOf(MediaType.JSON) + ", +json, " + Rdf.canRead().stream().map(MediaType::toString).collect(Collectors.joining(", ")) + "]");
    }
}

