/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CBannerLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public class CBanner
extends Composite {
    Control left;
    Control right;
    Control bottom;
    Sash separator;
    boolean simple = true;
    int[] curve;
    int curveStart = 0;
    Rectangle curveRect = new Rectangle(0, 0, 0, 0);
    int curve_width = 5;
    int curve_indent = -2;
    int rightWidth = -1;
    int rightMinWidth = 0;
    int rightMinHeight = 0;
    static final int OFFSCREEN = -200;
    static final int BORDER_BOTTOM = 2;
    static final int BORDER_TOP = 3;
    static final int BORDER_STRIPE = 1;
    static final int CURVE_TAIL = 200;
    static final int BEZIER_RIGHT = 30;
    static final int BEZIER_LEFT = 30;
    static final int MIN_LEFT = 10;

    public CBanner(Composite parent, int style) {
        super(parent, CBanner.checkStyle(style));
        super.setLayout(new CBannerLayout());
        this.separator = new Sash(this, 512);
        this.separator.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CBanner.this.onSepMove(event.x, event.width);
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                CBanner.this.onResize();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CBanner.this.onDispose();
            }
        });
    }

    static int[] bezier(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3, int count) {
        double a0 = x0;
        double a1 = 3 * (x1 - x0);
        double a2 = 3 * (x0 + x2 - 2 * x1);
        double a3 = x3 - x0 + 3 * x1 - 3 * x2;
        double b0 = y0;
        double b1 = 3 * (y1 - y0);
        double b2 = 3 * (y0 + y2 - 2 * y1);
        double b3 = y3 - y0 + 3 * y1 - 3 * y2;
        int[] polygon = new int[2 * count + 2];
        int i = 0;
        while (i <= count) {
            double t = (double)i / (double)count;
            polygon[2 * i] = (int)(a0 + a1 * t + a2 * t * t + a3 * t * t * t);
            polygon[2 * i + 1] = (int)(b0 + b1 * t + b2 * t * t + b3 * t * t * t);
            ++i;
        }
        return polygon;
    }

    static int checkStyle(int style) {
        return 0;
    }

    public Control getBottom() {
        this.checkWidget();
        return this.bottom;
    }

    public Rectangle getClientArea() {
        return new Rectangle(0, 0, 0, 0);
    }

    public Control getLeft() {
        this.checkWidget();
        return this.left;
    }

    public Control getRight() {
        this.checkWidget();
        return this.right;
    }

    public Point getRightMinimumSize() {
        this.checkWidget();
        return new Point(this.rightMinWidth, this.rightMinHeight);
    }

    public int getRightWidth() {
        this.checkWidget();
        if (this.right == null) {
            return 0;
        }
        if (this.rightWidth == -1) {
            Point size = this.right.computeSize(-1, -1, false);
            return size.x;
        }
        return this.rightWidth;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    void onDispose() {
        this.left = null;
        this.right = null;
        this.bottom = null;
    }

    void onResize() {
        this.updateCurve(this.getSize().y);
    }

    void onSepMove(int x, int width) {
        Point size = this.getSize();
        this.rightWidth = Math.max(0, size.x - x - this.curve_width + 2 * this.curve_indent);
        if (this.rightMinWidth == -1) {
            Point minSize = this.right.computeSize(this.rightMinWidth, this.rightMinHeight, false);
            this.rightWidth = Math.max(minSize.x, this.rightWidth);
        } else {
            this.rightWidth = Math.max(this.rightMinWidth, this.rightWidth);
        }
        this.layout();
    }

    public void setBottom(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.bottom != null && !this.bottom.isDisposed()) {
            Point size = this.bottom.getSize();
            this.bottom.setLocation(-200 - size.x, -200 - size.y);
        }
        this.bottom = control;
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setLeft(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.left != null && !this.left.isDisposed()) {
            Point size = this.left.getSize();
            this.left.setLocation(-200 - size.x, -200 - size.y);
        }
        this.left = control;
        this.layout();
    }

    public void setRight(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.right != null && !this.right.isDisposed()) {
            Point size = this.right.getSize();
            this.right.setLocation(-200 - size.x, -200 - size.y);
        }
        this.right = control;
        this.layout();
    }

    public void setRightMinimumSize(Point size) {
        this.checkWidget();
        if (size == null || size.x < -1 || size.y < -1) {
            SWT.error(5);
        }
        this.rightMinWidth = size.x;
        this.rightMinHeight = size.y;
        this.layout();
    }

    public void setRightWidth(int width) {
        this.checkWidget();
        if (width < -1) {
            SWT.error(5);
        }
        this.rightWidth = width;
        this.layout();
    }

    public void setSimple(boolean simple) {
        this.checkWidget();
        if (this.simple != simple) {
            this.simple = simple;
            if (simple) {
                this.curve_width = 5;
                this.curve_indent = -2;
            } else {
                this.curve_width = 50;
                this.curve_indent = 5;
            }
            this.updateCurve(this.getSize().y);
            this.layout();
            this.redraw();
        }
    }

    void updateCurve(int height) {
        int h = height - 1;
        if (this.simple) {
            int[] nArray = new int[14];
            nArray[1] = h;
            nArray[2] = 1;
            nArray[3] = h;
            nArray[4] = 2;
            nArray[5] = h - 1;
            nArray[6] = 3;
            nArray[7] = h - 2;
            nArray[8] = 3;
            nArray[9] = 2;
            nArray[10] = 4;
            nArray[11] = 1;
            nArray[12] = 5;
            this.curve = nArray;
        } else {
            this.curve = CBanner.bezier(0, h + 1, 30, h + 1, this.curve_width - 30, 0, this.curve_width, 0, this.curve_width);
        }
    }
}

