/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.IToolItemAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

final class ToolItemLCAUtil {
    private static final String PROP_VISIBLE = "visible";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_HOT_IMAGE = "hotImage";
    static final String PROP_SELECTION = "selection";
    private static final String QX_TYPE = "org.eclipse.rwt.widgets.ToolItem";
    static /* synthetic */ Class class$0;

    private ToolItemLCAUtil() {
    }

    static void preserveValues(ToolItem toolItem) {
        ItemLCAUtil.preserve((Item)toolItem);
        WidgetLCAUtil.preserveEnabled((Widget)toolItem, toolItem.getEnabled());
        WidgetLCAUtil.preserveToolTipText((Widget)toolItem, toolItem.getToolTipText());
        WidgetLCAUtil.preserveCustomVariant((Widget)toolItem);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)toolItem);
        adapter.preserve(PROP_VISIBLE, (Object)ToolItemLCAUtil.isVisible(toolItem));
        boolean hasListener = SelectionEvent.hasListener((Adaptable)toolItem);
        adapter.preserve("selectionListeners", (Object)hasListener);
        WidgetLCAUtil.preserveBounds((Widget)toolItem, toolItem.getBounds());
        adapter.preserve("menu", (Object)toolItem.getParent().getMenu());
    }

    static void renderInitialization(ToolItem toolItem, String param) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        ToolBar toolBar = toolItem.getParent();
        Integer index = new Integer(toolBar.indexOf(toolItem));
        Boolean flat = (toolBar.getStyle() & 0x800000) != 0;
        writer.newWidget(QX_TYPE, new Object[]{param, flat});
        writer.call((Widget)toolBar, "addAt", new Object[]{toolItem, index});
        WidgetLCAUtil.writeStyleFlag((Widget)toolItem, 0x800000, "FLAT");
        if ((toolBar.getStyle() & 0x200) != 0) {
            writer.call("addState", new Object[]{"rwt_VERTICAL"});
        }
    }

    static void renderChanges(ToolItem toolItem) throws IOException {
        ToolItemLCAUtil.writeText(toolItem);
        ToolItemLCAUtil.writeImages(toolItem);
        ToolItemLCAUtil.writeVisible(toolItem);
        ToolItemLCAUtil.writeBounds(toolItem);
        ToolItemLCAUtil.writeSelectionListener(toolItem);
        WidgetLCAUtil.writeToolTip((Widget)toolItem, toolItem.getToolTipText());
        WidgetLCAUtil.writeEnabled((Widget)toolItem, toolItem.getEnabled());
        WidgetLCAUtil.writeCustomVariant((Widget)toolItem);
    }

    static void writeSelectionListener(ToolItem toolItem) throws IOException {
        String prop = "selectionListeners";
        boolean hasListener = SelectionEvent.hasListener((Adaptable)toolItem);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)toolItem, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
            writer.set("hasSelectionListener", newValue);
        }
    }

    static void preserveSelection(ToolItem toolItem) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)toolItem);
        adapter.preserve(PROP_SELECTION, (Object)toolItem.getSelection());
    }

    static void writeSelection(ToolItem toolItem) throws IOException {
        Boolean newValue = toolItem.getSelection();
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        writer.set(PROP_SELECTION, PROP_SELECTION, newValue, Boolean.FALSE);
    }

    static void processSelection(ToolItem toolItem) {
        if (WidgetLCAUtil.wasEventSent((Widget)toolItem, "org.eclipse.swt.events.widgetSelected")) {
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            SelectionEvent event = ToolItemLCAUtil.newSelectionEvent((Widget)toolItem, bounds, 0);
            event.processEvent();
        }
    }

    static SelectionEvent newSelectionEvent(Widget widget, Rectangle bounds, int detail) {
        int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
        return new SelectionEvent(widget, null, 13, bounds, stateMask, null, true, detail);
    }

    static void writeVisible(ToolItem item) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IToolItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        IToolItemAdapter tia = (IToolItemAdapter)adapter;
        Boolean newValue = tia.getVisible();
        Boolean defValue = Boolean.TRUE;
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        writer.set(PROP_VISIBLE, "visibility", newValue, defValue);
    }

    private static boolean isVisible(ToolItem toolItem) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IToolItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = toolItem.getAdapter((Class)clazz);
        IToolItemAdapter toolItemAdapter = (IToolItemAdapter)adapter;
        return toolItemAdapter.getVisible();
    }

    static void writeBounds(ToolItem toolItem) throws IOException {
        Rectangle bounds = toolItem.getBounds();
        WidgetLCAUtil.writeBounds((Widget)toolItem, (Control)toolItem.getParent(), bounds);
    }

    static void writeText(ToolItem toolItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        String text = toolItem.getText();
        if (WidgetLCAUtil.hasChanged((Widget)toolItem, "text", text, null)) {
            writer.set("text", (text = WidgetLCAUtil.escapeText(text, true)).equals("") ? null : text);
        }
    }

    static void preserveImages(ToolItem toolItem) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)toolItem);
        adapter.preserve(PROP_IMAGE, (Object)ToolItemLCAUtil.getImage(toolItem));
        adapter.preserve(PROP_HOT_IMAGE, (Object)toolItem.getHotImage());
    }

    static void writeImages(ToolItem toolItem) throws IOException {
        Image hotImage;
        Image image = ToolItemLCAUtil.getImage(toolItem);
        if (WidgetLCAUtil.hasChanged((Widget)toolItem, PROP_IMAGE, image, null)) {
            ToolItemLCAUtil.writeImage(toolItem, PROP_IMAGE, image);
        }
        if (WidgetLCAUtil.hasChanged((Widget)toolItem, PROP_HOT_IMAGE, hotImage = toolItem.getHotImage(), null)) {
            ToolItemLCAUtil.writeImage(toolItem, PROP_HOT_IMAGE, hotImage);
        }
    }

    private static void writeImage(ToolItem toolItem, String jsProperty, Image image) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        Rectangle bounds = image != null ? image.getBounds() : null;
        Object[] args = new Object[]{ToolItemLCAUtil.getImagePath(image), new Integer(bounds != null ? bounds.width : 0), new Integer(bounds != null ? bounds.height : 0)};
        writer.set(jsProperty, args);
    }

    static Image getImage(ToolItem toolItem) {
        Image result;
        if (toolItem.getEnabled() && toolItem.getParent().getEnabled()) {
            result = toolItem.getImage();
        } else {
            result = toolItem.getDisabledImage();
            if (result == null) {
                result = toolItem.getImage();
            }
        }
        return result;
    }

    private static String getImagePath(Image image) {
        return image == null ? null : ImageFactory.getImagePath((Image)image);
    }
}

