/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.rwt.internal.ConfigurationReader;
import org.eclipse.rwt.internal.IEngineConfig;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.resources.ResourceRegistrationException;
import org.eclipse.rwt.internal.resources.ResourceUtil;
import org.eclipse.rwt.internal.resources.SystemProps;
import org.eclipse.rwt.internal.resources.WebAppURLs;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.internal.util.URLHelper;
import org.eclipse.rwt.resources.IResourceManager;

public class ResourceManagerImpl
implements IResourceManager {
    public static final String DELIVER_FROM_DISK = "deliverFromDisk";
    public static final String DELIVER_BY_SERVLET = "deliverByServlet";
    public static final String DELIVER_BY_SERVLET_AND_TEMP_DIR = "deliverByServletAndTempDir";
    public static final String RESOURCES = "rwt-resources";
    static final String RESOURCE = "w4t_resource";
    static final String RESOURCE_VERSION = "w4t_res_version";
    private final Map repository = new Hashtable();
    private final Map cache = new Hashtable();
    private String webAppRoot;
    private ClassLoader loader;
    private ThreadLocal contextLoader = new ThreadLocal();
    private String deliveryMode = "deliverByServlet";
    static /* synthetic */ Class class$0;

    static IResourceManager createInstance() {
        ResourceManagerImpl result = new ResourceManagerImpl();
        ConfigurationReader configurationReader = RWTFactory.getConfigurationReader();
        String resources = configurationReader.getConfiguration().getResources();
        File servletContextDir = configurationReader.getEngineConfig().getServerContextDir();
        result.webAppRoot = servletContextDir.toString();
        result.deliveryMode = resources;
        return result;
    }

    public byte[] findResource(String name, Integer version) {
        ParamCheck.notNull(name, "name");
        byte[] result = null;
        Resource resource = (Resource)this.cache.get(ResourceManagerImpl.createKey(name));
        if (resource != null && (version == null && resource.getVersion() == null || version != null && version.equals(resource.getVersion()))) {
            result = resource.getContent();
        }
        return result;
    }

    public Integer findVersion(String name) {
        ParamCheck.notNull(name, "name");
        Integer result = null;
        Resource resource = (Resource)this.cache.get(ResourceManagerImpl.createKey(name));
        if (resource != null) {
            result = resource.getVersion();
        }
        return result;
    }

    public boolean isDeliveryMode(String deliveryMode) {
        return this.deliveryMode.equals(deliveryMode);
    }

    public void register(String name) {
        ParamCheck.notNull(name, "name");
        this.doRegister(name, null, IResourceManager.RegisterOptions.NONE);
    }

    public void register(String name, String charset) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(charset, "charset");
        this.doRegister(name, charset, IResourceManager.RegisterOptions.NONE);
    }

    public void register(String name, String charset, IResourceManager.RegisterOptions options) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(charset, "charset");
        ParamCheck.notNull(options, "options");
        this.doRegister(name, charset, options);
    }

    public void register(String name, InputStream is) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(is, "is");
        String key = ResourceManagerImpl.createKey(name);
        try {
            byte[] content = ResourceUtil.readBinary(is);
            this.doRegister(name, null, IResourceManager.RegisterOptions.NONE, key, content);
        }
        catch (IOException e) {
            String text = "Failed to register resource ''{0}''.";
            String msg = MessageFormat.format(text, name);
            throw new ResourceRegistrationException(msg, e);
        }
        this.repository.put(key, name);
    }

    public void register(String name, InputStream is, String charset, IResourceManager.RegisterOptions options) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(is, "is");
        ParamCheck.notNull(charset, "charset");
        ParamCheck.notNull(options, "options");
        boolean compress = ResourceManagerImpl.shouldCompress(options);
        String key = ResourceManagerImpl.createKey(name);
        try {
            byte[] content = ResourceUtil.read(is, charset, compress);
            this.doRegister(name, charset, options, key, content);
        }
        catch (IOException ioe) {
            String msg = "Failed to register resource: " + name;
            throw new ResourceRegistrationException(msg, ioe);
        }
        this.repository.put(key, name);
    }

    public boolean unregister(String name) {
        ParamCheck.notNull(name, "name");
        boolean result = false;
        String key = ResourceManagerImpl.createKey(name);
        String fileName = (String)this.repository.remove(key);
        if (fileName != null) {
            result = true;
            Integer version = this.findVersion(name);
            File file = this.getDiskLocation(name, version);
            file.delete();
            this.cache.remove(key);
        }
        return result;
    }

    public String getCharset(String name) {
        ParamCheck.notNull(name, "name");
        Resource resource = (Resource)this.cache.get(ResourceManagerImpl.createKey(name));
        return resource.getCharset();
    }

    public boolean isRegistered(String name) {
        ParamCheck.notNull(name, "name");
        String key = ResourceManagerImpl.createKey(name);
        String fileName = (String)this.repository.get(key);
        return fileName != null;
    }

    public String getLocation(String name) {
        ParamCheck.notNull(name, "name");
        String key = ResourceManagerImpl.createKey(name);
        String fileName = (String)this.repository.get(key);
        return this.createRequestURL(fileName, this.findVersion(name));
    }

    public URL getResource(String name) {
        return this.getLoader().getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL resource = this.getLoader().getResource(name);
        InputStream result = null;
        if (resource != null) {
            try {
                URLConnection connection = resource.openConnection();
                connection.setUseCaches(false);
                result = connection.getInputStream();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public Enumeration getResources(String name) throws IOException {
        return this.getLoader().getResources(name);
    }

    public void setContextLoader(ClassLoader classLoader) {
        this.contextLoader.set(classLoader);
    }

    public ClassLoader getContextLoader() {
        return (ClassLoader)this.contextLoader.get();
    }

    public InputStream getRegisteredContent(String name) {
        FileInputStream result = null;
        String key = ResourceManagerImpl.createKey(name);
        String fileName = (String)this.repository.get(key);
        if (fileName != null) {
            File file = this.getDiskLocation(name, null);
            try {
                result = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClassLoader getLoader() {
        ClassLoader result = this.loader;
        if (this.getContextLoader() != null) {
            ClassLoader classLoader = this.getContextLoader();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rwt.internal.resources.ResourceManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (classLoader != clazz.getClassLoader()) {
                return this.getContextLoader();
            }
        }
        if (this.loader != null) return result;
        IEngineConfig engineConfig = RWTFactory.getConfigurationReader().getEngineConfig();
        List buffer = WebAppURLs.getWebAppURLs(engineConfig);
        URL[] urls = new URL[buffer.size()];
        buffer.toArray(urls);
        ClassLoader parent = this.getClass().getClassLoader();
        this.loader = new URLClassLoader(urls, parent);
        return this.loader;
    }

    private static String createKey(String name) {
        return String.valueOf(name.hashCode());
    }

    private String createRequestURL(String fileName, Integer version) {
        String result;
        String newFileName = fileName.replace('\\', '/');
        if (this.isDeliveryMode(DELIVER_FROM_DISK)) {
            StringBuffer url = new StringBuffer();
            url.append(RESOURCES);
            url.append("/");
            String escapedFilename = ResourceManagerImpl.escapeFilename(newFileName);
            url.append(ResourceManagerImpl.versionedResourceName(escapedFilename, version));
            result = url.toString();
        } else {
            StringBuffer url = new StringBuffer();
            url.append(URLHelper.getURLString());
            URLHelper.appendFirstParam(url, RESOURCE, newFileName);
            if (version != null) {
                URLHelper.appendParam(url, RESOURCE_VERSION, String.valueOf(version));
            }
            result = ContextProvider.getResponse().encodeURL(url.toString());
        }
        return result;
    }

    private void doRegister(String name, String charset, IResourceManager.RegisterOptions options) {
        String key = ResourceManagerImpl.createKey(name);
        if (!this.repository.containsKey(key)) {
            boolean compress = ResourceManagerImpl.shouldCompress(options);
            try {
                byte[] content = ResourceUtil.read(name, charset, compress, this);
                this.doRegister(name, charset, options, key, content);
            }
            catch (IOException e) {
                String text = "Failed to register resource ''{0}''.";
                String msg = MessageFormat.format(text, name);
                throw new ResourceRegistrationException(msg, e);
            }
            this.repository.put(key, name);
        }
    }

    private void doRegister(String name, String charset, IResourceManager.RegisterOptions options, String key, byte[] content) throws IOException {
        Integer version = ResourceManagerImpl.computeVersion(content, options);
        if (this.isDeliveryMode(DELIVER_FROM_DISK)) {
            File location = this.getDiskLocation(name, version);
            ResourceManagerImpl.createFile(location);
            ResourceUtil.write(location, content);
            this.cache.put(key, new Resource(null, charset, version));
        } else if (this.isDeliveryMode(DELIVER_BY_SERVLET)) {
            this.cache.put(key, new Resource(content, charset, version));
        } else if (this.isDeliveryMode(DELIVER_BY_SERVLET_AND_TEMP_DIR)) {
            File location = ResourceManagerImpl.getTempLocation(name, version);
            ResourceManagerImpl.createFile(location);
            ResourceUtil.write(location, content);
            this.cache.put(key, new Resource(content, charset, version));
        }
    }

    private static void createFile(File fileToWrite) throws IOException {
        File dir = new File(fileToWrite.getParent());
        if (!dir.mkdirs() && !dir.exists()) {
            throw new IOException("Could not create directory structure: " + dir);
        }
        if (!fileToWrite.exists()) {
            fileToWrite.createNewFile();
        }
    }

    private static Integer computeVersion(byte[] content, IResourceManager.RegisterOptions options) {
        Integer result = null;
        if (content != null && ResourceManagerImpl.shouldVersion(options)) {
            int version = 0;
            int i = 0;
            while (i < content.length) {
                version = version * 31 + content[i];
                ++i;
            }
            result = new Integer(version);
        }
        return result;
    }

    static String versionedResourceName(String name, Integer version) {
        String result = name;
        if (version != null) {
            String versionString = String.valueOf(version);
            int dotPos = name.lastIndexOf(46);
            if (name.replace('\\', '/').lastIndexOf("/") > dotPos) {
                dotPos = -1;
            }
            result = dotPos == -1 ? String.valueOf(name) + versionString : String.valueOf(name.substring(0, dotPos)) + versionString + name.substring(dotPos);
        }
        return result;
    }

    private static boolean shouldVersion(IResourceManager.RegisterOptions options) {
        return (options == IResourceManager.RegisterOptions.VERSION || options == IResourceManager.RegisterOptions.VERSION_AND_COMPRESS) && SystemProps.useVersionedJavaScript();
    }

    private static boolean shouldCompress(IResourceManager.RegisterOptions options) {
        return (options == IResourceManager.RegisterOptions.COMPRESS || options == IResourceManager.RegisterOptions.VERSION_AND_COMPRESS) && SystemProps.useCompressedJavaScript();
    }

    private File getDiskLocation(String name, Integer version) {
        StringBuffer filename = new StringBuffer();
        filename.append(this.webAppRoot);
        filename.append(File.separator);
        filename.append(RESOURCES);
        filename.append(File.separator);
        filename.append(ResourceManagerImpl.versionedResourceName(ResourceManagerImpl.escapeFilename(name), version));
        return new File(filename.toString());
    }

    private static String escapeFilename(String name) {
        String result = name;
        result = name.replaceAll("\\$", "\\$\\$");
        result = result.replaceAll(":", "\\$1");
        result = result.replaceAll("\\?", "\\$2");
        return result;
    }

    private static File getTempLocation(String name, Integer version) {
        StringBuffer result = new StringBuffer();
        result.append(System.getProperty("java.io.tmpdir"));
        result.append(File.separator);
        result.append(System.getProperty("user.name"));
        result.append(File.separator);
        result.append("w4toolkit");
        result.append(File.separator);
        result.append(ResourceManagerImpl.versionedResourceName(name, version));
        return new File(result.toString());
    }

    private static final class Resource {
        private final byte[] content;
        private final String charset;
        private final Integer version;

        public Resource(byte[] content, String charset, Integer version) {
            this.charset = charset;
            this.content = content;
            this.version = version;
        }

        public String getCharset() {
            return this.charset;
        }

        public byte[] getContent() {
            return this.content;
        }

        public Integer getVersion() {
            return this.version;
        }
    }
}

