/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.rwt.internal.resources.SystemProps;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rwt.internal.theme.css.StyleSheet;

public final class ThemeCssValuesMap {
    private final Map<PropertyKey, ConditionalValue[]> valuesMap;
    private final Theme theme;

    public ThemeCssValuesMap(Theme theme, StyleSheet styleSheet, ThemeableWidget[] themeableWidgets) {
        this.theme = theme;
        this.valuesMap = new LinkedHashMap<PropertyKey, ConditionalValue[]>();
        this.extractValues(styleSheet, themeableWidgets);
    }

    public ConditionalValue[] getValues(String elementName, String propertyName) {
        PropertyKey propertyKey = new PropertyKey(elementName, propertyName);
        ConditionalValue[] result = this.valuesMap.get(propertyKey);
        if (result == null) {
            PropertyKey wildcardKey = new PropertyKey("*", propertyName);
            result = this.valuesMap.get(wildcardKey);
        }
        return result;
    }

    public QxType[] getAllValues() {
        LinkedHashSet<QxType> resultSet = new LinkedHashSet<QxType>();
        Collection<ConditionalValue[]> values = this.valuesMap.values();
        Iterator<ConditionalValue[]> iterator = values.iterator();
        while (iterator.hasNext()) {
            ConditionalValue[] condValues;
            ConditionalValue[] conditionalValueArray = condValues = iterator.next();
            int n = condValues.length;
            int n2 = 0;
            while (n2 < n) {
                ConditionalValue condValue = conditionalValueArray[n2];
                resultSet.add(condValue.value);
                ++n2;
            }
        }
        return resultSet.toArray(new QxType[resultSet.size()]);
    }

    private void extractValues(StyleSheet styleSheet, ThemeableWidget[] themeableWidgets) {
        ThemeableWidget[] themeableWidgetArray = themeableWidgets;
        int n = themeableWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeableWidget themeableWidget = themeableWidgetArray[n2];
            this.extractValuesForWidget(styleSheet, themeableWidget);
            ++n2;
        }
    }

    private void extractValuesForWidget(StyleSheet styleSheet, ThemeableWidget themeableWidget) {
        if (themeableWidget.elements != null) {
            IThemeCssElement[] iThemeCssElementArray = themeableWidget.elements;
            int n = themeableWidget.elements.length;
            int n2 = 0;
            while (n2 < n) {
                String[] properties;
                IThemeCssElement element = iThemeCssElementArray[n2];
                String elementName = element.getName();
                String[] stringArray = properties = element.getProperties();
                int n3 = properties.length;
                int n4 = 0;
                while (n4 < n3) {
                    String propertyName = stringArray[n4];
                    PropertyKey key = new PropertyKey(elementName, propertyName);
                    ConditionalValue[] values = styleSheet.getValues(elementName, propertyName);
                    if (values.length == 0) {
                        this.reportMissingProperty(elementName, propertyName);
                    }
                    ConditionalValue[] filteredValues = this.filterValues(values, element);
                    this.valuesMap.put(key, filteredValues);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void reportMissingProperty(String elementName, String propertyName) {
        if (SystemProps.isDevelopmentMode() && SystemProps.enableThemeDebugOutput()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Missing value for element: '");
            stringBuilder.append(elementName);
            stringBuilder.append("' property: '");
            stringBuilder.append(propertyName);
            stringBuilder.append("' in theme: '");
            stringBuilder.append(this.theme.getId());
            stringBuilder.append("'");
            System.err.println(stringBuilder.toString());
        }
    }

    private ConditionalValue[] filterValues(ConditionalValue[] values, IThemeCssElement element) {
        ArrayList<ConditionalValue> resultList = new ArrayList<ConditionalValue>();
        Object[] latestConstraint = null;
        int j = 0;
        while (j < values.length) {
            ConditionalValue value = values[j];
            if (!Arrays.equals(latestConstraint, value.constraints) && ThemeCssValuesMap.matches(element, value.constraints)) {
                resultList.add(value);
                latestConstraint = value.constraints;
            }
            ++j;
        }
        return resultList.toArray(new ConditionalValue[resultList.size()]);
    }

    private static boolean matches(IThemeCssElement element, String[] constraints) {
        boolean passed = true;
        if (!"*".equals(element.getName())) {
            int k = 0;
            while (k < constraints.length && passed) {
                String constraint = constraints[k];
                if (constraint.charAt(0) == ':') {
                    passed &= ThemeCssValuesMap.contains(element.getStates(), constraint.substring(1));
                } else if (constraint.charAt(0) == '[') {
                    passed &= ThemeCssValuesMap.contains(element.getStyles(), constraint.substring(1));
                }
                ++k;
            }
        }
        return passed;
    }

    private static boolean contains(String[] elements, String string) {
        boolean result = false;
        int i = 0;
        while (i < elements.length && !result) {
            if (string.equals(elements[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static class PropertyKey {
        private final String element;
        private final String property;
        private final int hashCode;

        public PropertyKey(String element, String property) {
            this.element = element;
            this.property = property;
            this.hashCode = element.hashCode() ^ property.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj != null && obj.getClass() == this.getClass()) {
                PropertyKey other = (PropertyKey)obj;
                result = this.element.equals(other.element) && this.property.equals(other.property);
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

