/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.internal.GridItemData;
import org.eclipse.nebula.widgets.grid.internal.IGridItemAdapter;
import org.eclipse.nebula.widgets.grid.internal.griditemkit.GridItemLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridItem
extends Item {
    private Grid parent;
    private GridItem parentItem;
    private GridItemData data;
    private boolean hasChildren;
    private boolean visible = true;
    private boolean cached;
    private transient IGridItemAdapter gridItemAdapter;
    int index;

    public GridItem(Grid parent, int style) {
        this(parent, null, style, -1);
    }

    public GridItem(Grid parent, int style, int index) {
        this(parent, null, style, index);
    }

    public GridItem(GridItem parent, int style) {
        this(parent == null ? null : parent.parent, parent, style, -1);
    }

    public GridItem(GridItem parent, int style, int index) {
        this(parent == null ? null : parent.parent, parent, style, index);
    }

    GridItem(Grid parent, GridItem parentItem, int style, int index) {
        super((Widget)parent, style, index);
        this.parent = parent;
        this.parentItem = parentItem;
        if (parentItem == null) {
            parent.newItem(this, index, true);
            parent.newRootItem(this, index);
        } else {
            parent.newItem(this, index, false);
            parentItem.newItem(this, index);
            this.setVisible(parentItem.isVisible() && parentItem.isExpanded());
        }
    }

    public void dispose() {
        this.dispose(-1);
    }

    void dispose(int flatIndex) {
        if (!this.parent.isDisposing() && !this.isDisposed()) {
            int index;
            if (this.data != null) {
                int i = 0;
                while (i < this.parent.getColumnCount()) {
                    GridItemData.CellData itemData = this.getCellData(i);
                    this.updateColumnImageCount(i, itemData.image, null);
                    this.updateColumnTextCount(i, itemData.text, "");
                    ++i;
                }
            }
            int n = index = flatIndex == -1 ? this.parent.internalIndexOf(this) : flatIndex;
            if (this.hasChildren) {
                List<GridItem> children = this.getItemData().getChildren();
                while (this.hasChildren) {
                    children.get(0).dispose(index + 1);
                }
            }
            this.parent.removeItem(index);
            if (this.parentItem != null) {
                this.parentItem.removeItem(this.index);
            } else {
                this.parent.removeRootItem(this.index);
            }
        }
        super.dispose();
    }

    public void fireEvent(int eventId) {
        this.checkWidget();
        Event event = new Event();
        event.display = this.getDisplay();
        event.widget = this;
        event.item = this;
        event.type = eventId;
        this.getParent().notifyListeners(eventId, event);
    }

    public void fireCheckEvent(int column) {
        this.checkWidget();
        Event event = new Event();
        event.display = this.getDisplay();
        event.widget = this;
        event.item = this;
        event.type = 13;
        event.detail = 32;
        event.index = column;
        this.getParent().notifyListeners(13, event);
    }

    public Grid getParent() {
        this.checkWidget();
        return this.parent;
    }

    public GridItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.hasChildren ? this.getItemData().getChildren().size() : 0;
    }

    public GridItem[] getItems() {
        this.checkWidget();
        if (this.hasChildren) {
            return this.getItemData().getChildren().toArray(new GridItem[0]);
        }
        return new GridItem[0];
    }

    public GridItem getItem(int index) {
        this.checkWidget();
        if (!this.hasChildren) {
            throw new IllegalArgumentException("GridItem has no children!");
        }
        return this.getItemData().getChildren().get(index);
    }

    public int indexOf(GridItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.isDisposed()) {
            SWT.error((int)5);
        }
        if (!this.hasChildren) {
            throw new IllegalArgumentException("GridItem has no children!");
        }
        return item.getParentItem() == this ? item.index : -1;
    }

    public boolean hasChildren() {
        this.checkWidget();
        return this.hasChildren;
    }

    public boolean isExpanded() {
        this.checkWidget();
        return this.data == null ? false : this.data.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        if (this.getItemData().expanded != expanded) {
            this.getItemData().expanded = expanded;
            boolean unselected = false;
            if (this.hasChildren) {
                for (GridItem item : this.getItemData().getChildren()) {
                    item.setVisible(expanded && this.visible);
                    if (expanded) continue;
                    if (this.parent.isSelected(item)) {
                        this.parent.deselect(this.parent.internalIndexOf(item));
                        unselected = true;
                    }
                    if (!this.deselectChildren(item)) continue;
                    unselected = true;
                }
            }
            this.parent.scheduleRedraw();
            if (unselected) {
                Event event = new Event();
                event.item = this;
                this.parent.notifyListeners(13, event);
            }
            if (this.parent.getFocusItem() != null && !this.parent.getFocusItem().isVisible()) {
                this.parent.setFocusItem(this);
            }
            this.markCached();
        }
    }

    public int getLevel() {
        this.checkWidget();
        return this.parentItem == null ? 0 : this.parentItem.getLevel() + 1;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.getItemData().defaultFont = font;
        this.markCached();
        this.parent.scheduleRedraw();
    }

    public Font getFont() {
        this.checkWidget();
        this.handleVirtual();
        Font defaultFont = this.getItemData().defaultFont;
        return defaultFont == null ? this.parent.getFont() : defaultFont;
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.getCellData((int)index).font = font;
        this.markCached();
        this.parent.scheduleRedraw();
    }

    public Font getFont(int index) {
        this.checkWidget();
        this.handleVirtual();
        Font result = this.getCellData((int)index).font;
        if (result == null) {
            result = this.getFont();
        }
        return result;
    }

    public void setBackground(Color background) {
        this.checkWidget();
        if (background != null && background.isDisposed()) {
            SWT.error((int)5);
        }
        this.getItemData().defaultBackground = background;
        this.markCached();
    }

    public Color getBackground() {
        this.checkWidget();
        this.handleVirtual();
        Color defaultBackground = this.getItemData().defaultBackground;
        return defaultBackground == null ? this.parent.getBackground() : defaultBackground;
    }

    public void setBackground(int index, Color background) {
        this.checkWidget();
        if (background != null && background.isDisposed()) {
            SWT.error((int)5);
        }
        this.getCellData((int)index).background = background;
        this.markCached();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        this.handleVirtual();
        Color result = this.getCellData((int)index).background;
        if (result == null) {
            result = this.getBackground();
        }
        return result;
    }

    public void setForeground(Color foreground) {
        this.checkWidget();
        if (foreground != null && foreground.isDisposed()) {
            SWT.error((int)5);
        }
        this.getItemData().defaultForeground = foreground;
        this.markCached();
    }

    public Color getForeground() {
        this.checkWidget();
        this.handleVirtual();
        Color defaultForeground = this.getItemData().defaultForeground;
        return defaultForeground == null ? this.parent.getForeground() : defaultForeground;
    }

    public void setForeground(int index, Color foreground) {
        this.checkWidget();
        if (foreground != null && foreground.isDisposed()) {
            SWT.error((int)5);
        }
        this.getCellData((int)index).foreground = foreground;
        this.markCached();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        this.handleVirtual();
        Color result = this.getCellData((int)index).foreground;
        if (result == null) {
            result = this.getForeground();
        }
        return result;
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public String getText() {
        this.checkWidget();
        return this.getText(0);
    }

    public void setText(int index, String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        if (MarkupUtil.isMarkupEnabledFor((Widget)this.parent) && !MarkupValidator.isValidationDisabledFor((Widget)this.parent)) {
            MarkupValidator.getInstance().validate(text);
        }
        GridItemData.CellData cellData = this.getCellData(index);
        this.updateColumnTextCount(index, cellData.text, text);
        cellData.text = text;
        this.markCached();
    }

    public String getText(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getCellData((int)index).text;
    }

    public void setToolTipText(int index, String tooltip) {
        this.checkWidget();
        this.getCellData((int)index).tooltip = tooltip;
        if (tooltip != null && tooltip.length() > 0) {
            this.parent.setCellToolTipsEnabled(true);
        }
        this.markCached();
    }

    public String getToolTipText(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getCellData((int)index).tooltip;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error((int)5);
        }
        GridItemData.CellData cellData = this.getCellData(index);
        this.updateColumnImageCount(index, cellData.image, image);
        cellData.image = image;
        this.parent.imageSetOnItem(index, this);
        this.markCached();
    }

    public Image getImage(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getCellData((int)index).image;
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        this.setChecked(0, checked);
    }

    public boolean getChecked() {
        this.checkWidget();
        return this.getChecked(0);
    }

    public void setChecked(int index, boolean checked) {
        this.checkWidget();
        this.getCellData((int)index).checked = checked;
        this.markCached();
    }

    public boolean getChecked(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getCellData((int)index).checked;
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        this.setGrayed(0, grayed);
    }

    public boolean getGrayed() {
        this.checkWidget();
        return this.getGrayed(0);
    }

    public void setGrayed(int index, boolean grayed) {
        this.checkWidget();
        this.getCellData((int)index).grayed = grayed;
        this.markCached();
    }

    public boolean getGrayed(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getCellData((int)index).grayed;
    }

    public void setCheckable(int index, boolean checked) {
        this.checkWidget();
        this.getCellData((int)index).checkable = checked;
        this.markCached();
    }

    public boolean getCheckable(int index) {
        this.checkWidget();
        this.handleVirtual();
        boolean result = this.getCellData((int)index).checkable;
        if (this.parent.getColumnCount() > 0 && !this.parent.getColumn(index).getCheckable()) {
            result = false;
        }
        return result;
    }

    public void setColumnSpan(int index, int span) {
        this.checkWidget();
        this.getCellData((int)index).columnSpan = span;
        this.parent.setHasSpanning(true);
    }

    public int getColumnSpan(int index) {
        this.checkWidget();
        return this.getCellData((int)index).columnSpan;
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height < 1) {
            SWT.error((int)5);
        }
        if (this.getItemData().customHeight != height) {
            this.getItemData().customHeight = height;
            this.parent.hasDifferingHeights = true;
            this.markCached();
            this.parent.scheduleRedraw();
        }
    }

    public int getHeight() {
        this.checkWidget();
        int customHeight = this.getItemData().customHeight;
        return customHeight != -1 ? customHeight : this.parent.getItemHeight();
    }

    public void pack() {
        this.checkWidget();
        this.parent.layoutCache.invalidateItemHeight();
    }

    public Rectangle getBounds(int columnIndex) {
        this.checkWidget();
        if (this.isVisible() && this.parent.isShown(this)) {
            Point origin = this.parent.getOrigin(this.parent.getColumn(columnIndex), this);
            Point cellSize = this.getCellSize(columnIndex);
            return new Rectangle(origin.x, origin.y, cellSize.x, cellSize.y);
        }
        return new Rectangle(-1000, -1000, 0, 0);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWidgetFontAdapter.class || adapter == IWidgetColorAdapter.class || adapter == IGridItemAdapter.class) {
            if (this.gridItemAdapter == null) {
                this.gridItemAdapter = new GridItemAdapter();
            }
            return (T)this.gridItemAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)((Object)GridItemLCA.INSTANCE);
        }
        return (T)super.getAdapter(adapter);
    }

    public boolean isVisible() {
        return this.visible;
    }

    void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.parent.updateVisibleItems(visible ? 1 : -1);
            if (this.hasChildren) {
                for (GridItem item : this.getItemData().getChildren()) {
                    item.setVisible(visible && this.isExpanded());
                }
            }
        }
    }

    private void newItem(GridItem item, int index) {
        List<GridItem> children = this.getItemData().getChildren();
        if (index == -1) {
            children.add(item);
            item.index = children.size() - 1;
        } else {
            children.add(index, item);
            item.index = index;
        }
        this.adjustItemIndices(item.index + 1);
        this.hasChildren = true;
    }

    private void removeItem(int index) {
        if (!this.hasChildren) {
            throw new IllegalArgumentException("GridItem has no children!");
        }
        List<GridItem> children = this.getItemData().getChildren();
        children.remove(index);
        this.adjustItemIndices(index);
        this.hasChildren = children.size() > 0;
    }

    private void adjustItemIndices(int start) {
        List<GridItem> children = this.getItemData().getChildren();
        int i = start;
        while (i < children.size()) {
            children.get((int)i).index = i;
            ++i;
        }
    }

    void columnAdded(int index) {
        if (this.data != null && this.parent.getColumnCount() > 1) {
            this.data.addCellData(index);
        }
    }

    void columnRemoved(int index) {
        if (this.data != null && this.parent.getColumnCount() > 0) {
            this.data.removeCellData(index);
        }
    }

    void clear(boolean allChildren) {
        if (this.data != null) {
            int i = 0;
            while (i < this.parent.getColumnCount()) {
                GridItemData.CellData cellData = this.getCellData(i);
                this.updateColumnImageCount(i, cellData.image, null);
                this.updateColumnTextCount(i, cellData.text, "");
                ++i;
            }
            this.data.clear();
        }
        this.cached = false;
        if (allChildren && this.hasChildren) {
            List<GridItem> children = this.getItemData().getChildren();
            int i = children.size() - 1;
            while (i >= 0) {
                children.get(i).clear(true);
                --i;
            }
        }
    }

    int getPreferredWidth(int index) {
        int result = this.getIndentationWidth(index);
        result += this.getPaddingWidth(index);
        result += this.getCheckBoxWidth(index);
        result += this.getImageWidth(index);
        result += this.getSpacing(index);
        return result += this.getTextWidth(index);
    }

    private int getIndentationWidth(int index) {
        int result = 0;
        if (this.parent.isTreeColumn(index)) {
            result = (this.getLevel() + 1) * this.parent.getIndentationWidth();
        }
        return result;
    }

    private int getPaddingWidth(int index) {
        BoxDimensions cellPadding = this.parent.getCellPadding();
        int result = cellPadding.left + cellPadding.right;
        if (this.parent.isTreeColumn(index)) {
            result -= this.parent.getCellPadding().left;
        }
        return result;
    }

    private int getCheckBoxWidth(int index) {
        return this.parent.getColumn(index).isCheck() ? this.parent.getCheckBoxImageOuterSize().width : 0;
    }

    private int getImageWidth(int index) {
        int result = 0;
        if (this.parent.hasColumnImages(index)) {
            result = this.parent.getItemImageSize().x;
        }
        return result;
    }

    private int getSpacing(int index) {
        int result = 0;
        String text = this.getCellData((int)index).text;
        if (this.parent.hasColumnImages(index) && text.length() > 0) {
            result = this.parent.getCellSpacing();
        }
        return result;
    }

    private int getTextWidth(int index) {
        String text = this.getCellData((int)index).text;
        if (text.length() > 0) {
            return TextSizeUtil.stringExtent((Font)this.internalGetFont((int)index), (String)text, (boolean)MarkupUtil.isMarkupEnabledFor((Widget)this.parent)).x;
        }
        return 0;
    }

    int getTextOffset(int index) {
        int result = this.getIndentationWidth(index);
        if (!this.parent.isTreeColumn(index)) {
            result += this.parent.getCellPadding().left;
        }
        result += this.getCheckBoxWidth(index);
        result += this.getImageWidth(index);
        return result += this.getSpacing(index);
    }

    private Font internalGetFont(int index) {
        Font result = this.getCellData((int)index).font;
        if (result == null) {
            result = this.getItemData().defaultFont;
        }
        if (result == null) {
            result = this.parent.getFont();
        }
        return result;
    }

    protected Point getCellSize(int index) {
        int width = 0;
        int span = this.getColumnSpan(index);
        int i = 0;
        while (i <= span && i < this.parent.getColumnCount() - index) {
            width += this.parent.getColumn(index + i).getWidth();
            ++i;
        }
        GridItem item = this;
        int itemIndex = this.parent.internalIndexOf(item);
        int height = this.getHeight();
        span = 0;
        int i2 = 1;
        while (i2 <= span && i2 < this.parent.getItemCount() - itemIndex) {
            item = this.parent.getItem(itemIndex + i2);
            if (item.isVisible()) {
                height += item.getHeight();
            }
            ++i2;
        }
        return new Point(width, height);
    }

    private GridItemData.CellData getCellData(int index) {
        return this.getItemData().getCellData(index);
    }

    private GridItemData getItemData() {
        this.ensureItemData();
        return this.data;
    }

    void ensureItemData() {
        if (this.data == null) {
            this.data = new GridItemData(this.parent.getColumnCount());
        }
    }

    void handleVirtual() {
        if (!this.isCached()) {
            this.markCached();
            Event event = new Event();
            event.item = this;
            event.index = this.index;
            this.parent.notifyListeners(36, event);
        }
    }

    private boolean deselectChildren(GridItem item) {
        boolean flag = false;
        GridItem[] gridItemArray = item.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem child = gridItemArray[n2];
            if (this.parent.isSelected(child)) {
                flag = true;
            }
            this.parent.deselect(this.parent.internalIndexOf(child));
            if (this.deselectChildren(child)) {
                flag = true;
            }
            ++n2;
        }
        return flag;
    }

    private void updateColumnImageCount(int index, Image oldImage, Image newImage) {
        int delta = 0;
        if (oldImage == null && newImage != null) {
            delta = 1;
        } else if (oldImage != null && newImage == null) {
            delta = -1;
        }
        if (delta != 0 && index >= 0 && index < this.parent.getColumnCount()) {
            this.parent.getColumn((int)index).imageCount += delta;
        }
    }

    private void updateColumnTextCount(int index, String oldText, String newText) {
        int delta = 0;
        if (oldText.length() == 0 && newText.length() > 0) {
            delta = 1;
        } else if (oldText.length() > 0 && newText.length() == 0) {
            delta = -1;
        }
        if (delta != 0 && index >= 0 && index < this.parent.getColumnCount()) {
            this.parent.getColumn((int)index).textCount += delta;
        }
    }

    boolean isCached() {
        return this.parent.isVirtual() ? this.cached : true;
    }

    private void markCached() {
        if (this.parent.isVirtual()) {
            this.cached = true;
        }
    }

    boolean isResolved() {
        return this.parent.isVirtual() ? this.data != null : true;
    }

    private final class GridItemAdapter
    implements IGridItemAdapter,
    IWidgetFontAdapter,
    IWidgetColorAdapter {
        private GridItemAdapter() {
        }

        @Override
        public boolean isParentDisposed() {
            Object itemParent = GridItem.this.parentItem == null ? GridItem.this.parent : GridItem.this.parentItem;
            return itemParent.isDisposed();
        }

        @Override
        public boolean isCached() {
            return GridItem.this.isCached();
        }

        public Color getUserBackground() {
            return ((GridItem)GridItem.this).getItemData().defaultBackground;
        }

        public Color getUserForeground() {
            return ((GridItem)GridItem.this).getItemData().defaultForeground;
        }

        public Font getUserFont() {
            return ((GridItem)GridItem.this).getItemData().defaultFont;
        }

        @Override
        public String[] getTexts() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            Object[] result = null;
            int i = 0;
            while (i < columnCount) {
                String text = ((GridItem)GridItem.this).getCellData((int)i).text;
                if (!"".equals(text)) {
                    if (result == null) {
                        result = new String[columnCount];
                        Arrays.fill(result, "");
                    }
                    result[i] = text;
                }
                ++i;
            }
            return result;
        }

        @Override
        public Image[] getImages() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            Image[] result = null;
            int i = 0;
            while (i < columnCount) {
                Image image = ((GridItem)GridItem.this).getCellData((int)i).image;
                if (image != null) {
                    if (result == null) {
                        result = new Image[columnCount];
                    }
                    result[i] = image;
                }
                ++i;
            }
            return result;
        }

        @Override
        public Color[] getCellBackgrounds() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            Color[] result = null;
            int i = 0;
            while (i < columnCount) {
                Color background = ((GridItem)GridItem.this).getCellData((int)i).background;
                if (background != null) {
                    if (result == null) {
                        result = new Color[columnCount];
                    }
                    result[i] = background;
                }
                ++i;
            }
            return result;
        }

        @Override
        public Color[] getCellForegrounds() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            Color[] result = null;
            int i = 0;
            while (i < columnCount) {
                Color foreground = ((GridItem)GridItem.this).getCellData((int)i).foreground;
                if (foreground != null) {
                    if (result == null) {
                        result = new Color[columnCount];
                    }
                    result[i] = foreground;
                }
                ++i;
            }
            return result;
        }

        @Override
        public Font[] getCellFonts() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            Font[] result = null;
            int i = 0;
            while (i < columnCount) {
                Font font = ((GridItem)GridItem.this).getCellData((int)i).font;
                if (font != null) {
                    if (result == null) {
                        result = new Font[columnCount];
                    }
                    result[i] = font;
                }
                ++i;
            }
            return result;
        }

        @Override
        public boolean[] getCellChecked() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            boolean[] result = null;
            int i = 0;
            while (i < columnCount) {
                boolean checked = ((GridItem)GridItem.this).getCellData((int)i).checked;
                if (checked) {
                    if (result == null) {
                        result = new boolean[columnCount];
                    }
                    result[i] = checked;
                }
                ++i;
            }
            return result;
        }

        @Override
        public boolean[] getCellGrayed() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            boolean[] result = null;
            int i = 0;
            while (i < columnCount) {
                boolean grayed = ((GridItem)GridItem.this).getCellData((int)i).grayed;
                if (grayed) {
                    if (result == null) {
                        result = new boolean[columnCount];
                    }
                    result[i] = grayed;
                }
                ++i;
            }
            return result;
        }

        @Override
        public boolean[] getCellCheckable() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            boolean[] result = null;
            int i = 0;
            while (i < columnCount) {
                boolean checkable = ((GridItem)GridItem.this).getCellData((int)i).checkable;
                if (!checkable) {
                    if (result == null) {
                        result = new boolean[columnCount];
                        Arrays.fill(result, true);
                    }
                    result[i] = checkable;
                }
                ++i;
            }
            return result;
        }

        @Override
        public int[] getColumnSpans() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            int[] result = null;
            int i = 0;
            while (i < columnCount) {
                int span = ((GridItem)GridItem.this).getCellData((int)i).columnSpan;
                if (span != 0) {
                    if (result == null) {
                        result = new int[columnCount];
                    }
                    result[i] = span;
                }
                ++i;
            }
            return result;
        }
    }
}

