/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.model.model1902.Geodaten;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMV Profil Art</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * ES: Erhöhte Seitenbeschleunigung
 * <!-- end-model-doc -->
 * @see org.eclipse.set.model.model1902.Geodaten.GeodatenPackage#getENUMVProfilArt()
 * @model extendedMetaData="name='ENUMV_Profil_Art'"
 * @generated
 */
public enum ENUMVProfilArt implements Enumerator {
	/**
	 * The '<em><b>ENUMV Profil Art anzeigegeführt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_ANZEIGEGEFÜHRT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMV_PROFIL_ART_ANZEIGEGEFÜHRT(0, "ENUMV_Profil_Art_anzeigegeführt", "anzeigegef\u00fchrt"),

	/**
	 * The '<em><b>ENUMV Profil Art signalgeführt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_SIGNALGEFÜHRT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMV_PROFIL_ART_SIGNALGEFÜHRT(1, "ENUMV_Profil_Art_signalgeführt", "signalgef\u00fchrt"),

	/**
	 * The '<em><b>ENUMV Profil Art signalgeführt ES</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_SIGNALGEFÜHRT_ES_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMV_PROFIL_ART_SIGNALGEFÜHRT_ES(2, "ENUMV_Profil_Art_signalgeführt_ES", "signalgef\u00fchrt ES"),

	/**
	 * The '<em><b>ENUMV Profil Art sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMV_PROFIL_ART_SONSTIGE(3, "ENUMV_Profil_Art_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUMV Profil Art windabhängig</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_WINDABHÄNGIG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMV_PROFIL_ART_WINDABHÄNGIG(4, "ENUMV_Profil_Art_windabhängig", "windabh\u00e4ngig");

	/**
	 * The '<em><b>ENUMV Profil Art anzeigegeführt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_ANZEIGEGEFÜHRT
	 * @model name="ENUMV_Profil_Art_anzeigegeführt" literal="anzeigegef\374hrt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMV_PROFIL_ART_ANZEIGEGEFÜHRT_VALUE = 0;

	/**
	 * The '<em><b>ENUMV Profil Art signalgeführt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_SIGNALGEFÜHRT
	 * @model name="ENUMV_Profil_Art_signalgeführt" literal="signalgef\374hrt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMV_PROFIL_ART_SIGNALGEFÜHRT_VALUE = 1;

	/**
	 * The '<em><b>ENUMV Profil Art signalgeführt ES</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_SIGNALGEFÜHRT_ES
	 * @model name="ENUMV_Profil_Art_signalgeführt_ES" literal="signalgef\374hrt ES"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMV_PROFIL_ART_SIGNALGEFÜHRT_ES_VALUE = 2;

	/**
	 * The '<em><b>ENUMV Profil Art sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_SONSTIGE
	 * @model name="ENUMV_Profil_Art_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMV_PROFIL_ART_SONSTIGE_VALUE = 3;

	/**
	 * The '<em><b>ENUMV Profil Art windabhängig</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMV_PROFIL_ART_WINDABHÄNGIG
	 * @model name="ENUMV_Profil_Art_windabhängig" literal="windabh\344ngig"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMV_PROFIL_ART_WINDABHÄNGIG_VALUE = 4;

	/**
	 * An array of all the '<em><b>ENUMV Profil Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMVProfilArt[] VALUES_ARRAY =
		new ENUMVProfilArt[] {
			ENUMV_PROFIL_ART_ANZEIGEGEFÜHRT,
			ENUMV_PROFIL_ART_SIGNALGEFÜHRT,
			ENUMV_PROFIL_ART_SIGNALGEFÜHRT_ES,
			ENUMV_PROFIL_ART_SONSTIGE,
			ENUMV_PROFIL_ART_WINDABHÄNGIG,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMV Profil Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMVProfilArt> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMV Profil Art</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMVProfilArt get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMVProfilArt result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMV Profil Art</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMVProfilArt getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMVProfilArt result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMV Profil Art</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMVProfilArt get(int value) {
		switch (value) {
			case ENUMV_PROFIL_ART_ANZEIGEGEFÜHRT_VALUE: return ENUMV_PROFIL_ART_ANZEIGEGEFÜHRT;
			case ENUMV_PROFIL_ART_SIGNALGEFÜHRT_VALUE: return ENUMV_PROFIL_ART_SIGNALGEFÜHRT;
			case ENUMV_PROFIL_ART_SIGNALGEFÜHRT_ES_VALUE: return ENUMV_PROFIL_ART_SIGNALGEFÜHRT_ES;
			case ENUMV_PROFIL_ART_SONSTIGE_VALUE: return ENUMV_PROFIL_ART_SONSTIGE;
			case ENUMV_PROFIL_ART_WINDABHÄNGIG_VALUE: return ENUMV_PROFIL_ART_WINDABHÄNGIG;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMVProfilArt(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMVProfilArt
