/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.genericxy;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.ISampling;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.AbstractTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public abstract class AbstractTreeGenericXYCommonXDataProvider<A extends TmfStateSystemAnalysisModule, M extends ITmfTreeDataModel>
extends AbstractTreeDataProvider<A, M>
implements ITmfTreeXYDataProvider<M> {
    public AbstractTreeGenericXYCommonXDataProvider(ITmfTrace trace, A analysisModule) {
        super(trace, analysisModule);
    }

    @Override
    public TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Object module = this.getAnalysisModule();
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQueryWithSamples(fetchParameters);
        if (filter == null) {
            return TmfXyResponseFactory.createFailedResponse(CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        TmfModelResponse<ITmfXyModel> res = this.verifyParameters((TmfStateSystemAnalysisModule)module, filter, monitor);
        if (res != null) {
            return res;
        }
        ITmfStateSystem ss = Objects.requireNonNull(((TmfStateSystemAnalysisModule)module).getStateSystem(), "Statesystem should have been verified by verifyParameters");
        long currentEnd = ss.getCurrentEndTime();
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        try {
            Throwable throwable = null;
            Object var11_12 = null;
            try (LogUtils.FlowScopeLog scope = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractTreeGenericXYCommonXDataProvider#fetchXY", new Object[0]).setCategory(this.getClass().getSimpleName()).build();){
                Pair<ISampling, Collection<IYModel>> xAxisAndYSeriesModels = this.getXAxisAndYSeriesModels(ss, fetchParameters, monitor);
                if (xAxisAndYSeriesModels == null) {
                    return TmfXyResponseFactory.createCancelledResponse(CommonStatusMessage.TASK_CANCELLED);
                }
                return TmfXyResponseFactory.create(this.getTitle(), xAxisAndYSeriesModels.getFirst(), (Collection<IYModel>)ImmutableList.copyOf(xAxisAndYSeriesModels.getSecond()), this.getDisplayType(), this.getXAxisDescription(), complete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return TmfXyResponseFactory.createFailedResponse(String.valueOf(e.getMessage()));
        }
    }

    protected ISeriesModel.DisplayType getDisplayType() {
        return ISeriesModel.DisplayType.BAR;
    }

    protected abstract TmfXYAxisDescription getXAxisDescription();

    protected abstract @Nullable Pair<ISampling, Collection<IYModel>> getXAxisAndYSeriesModels(ITmfStateSystem var1, Map<String, Object> var2, @Nullable IProgressMonitor var3) throws StateSystemDisposedException;

    protected abstract String getTitle();
}

