/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenWithBrowserAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.open.browser";

    public OpenWithBrowserAction() {
        super(Messages.OpenWithBrowserAction_Open_with_Browser);
        this.setToolTipText(Messages.OpenWithBrowserAction_Open_with_Browser);
        this.setId(ID);
    }

    public void run() {
        if (super.getStructuredSelection() != null) {
            Iterator iter = super.getStructuredSelection().iterator();
            while (iter.hasNext()) {
                this.runWithSelection(iter.next());
            }
        }
    }

    private void runWithSelection(Object selectedObject) {
        if (selectedObject instanceof IRepositoryElement) {
            TasksUiUtil.openWithBrowser((IRepositoryElement)selectedObject);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object element : selection.toList()) {
                String url;
                TaskRepository repository;
                if (!(element instanceof IRepositoryElement) || (repository = TasksUiInternal.getRepository((IRepositoryElement)element)) == null || !TasksUiInternal.isValidUrl(url = TasksUiInternal.getAuthenticatedUrl(repository, (IRepositoryElement)element))) continue;
                return true;
            }
        }
        return false;
    }
}

