/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

abstract class PreferenceStore {
    private PreferenceStore() {
    }

    abstract String readString(String var1, String var2);

    abstract boolean readBoolean(String var1, boolean var2);

    abstract void write(String var1, String var2);

    abstract void writeBoolean(String var1, boolean var2);

    void delete(String key) {
        this.write(key, null);
    }

    abstract void flush();

    static PreferenceStore forProjectScope(IProject project, String node) {
        return new ProjectScopeEclipsePreferencesPreferenceStore(project, node);
    }

    static PreferenceStore forPreferenceFile(File propertiesFile) {
        return new PropertiesFilePreferenceStore(propertiesFile);
    }

    private static final class ProjectScopeEclipsePreferencesPreferenceStore
    extends PreferenceStore {
        private final IProject project;
        private final String node;
        private final IEclipsePreferences preferences;

        private ProjectScopeEclipsePreferencesPreferenceStore(IProject project, String node) {
            this.project = project;
            this.node = node;
            this.preferences = new ProjectScope(project).getNode(node);
        }

        @Override
        String readString(String key, String defaultValue) {
            return this.preferences.get(key, defaultValue);
        }

        @Override
        boolean readBoolean(String key, boolean defaultValue) {
            return this.preferences.getBoolean(key, defaultValue);
        }

        @Override
        void write(String key, String value) {
            if (value == null) {
                this.preferences.remove(key);
            } else {
                this.preferences.put(key, value);
            }
        }

        @Override
        void writeBoolean(String key, boolean value) {
            this.preferences.putBoolean(key, value);
        }

        @Override
        void flush() {
            try {
                this.preferences.flush();
            }
            catch (Exception e) {
                throw new GradlePluginsRuntimeException(String.format("Cannot store preferences in project %s in node %s.", this.project.getName(), this.node), e);
            }
        }
    }

    private static final class PropertiesFilePreferenceStore
    extends PreferenceStore {
        private final File propertiesFile;
        private Properties properties;

        private PropertiesFilePreferenceStore(File propertiesFile) {
            this.propertiesFile = propertiesFile;
        }

        private Properties getProperties() {
            if (this.properties == null) {
                this.loadProperties();
            }
            return this.properties;
        }

        private void loadProperties() {
            InputStreamReader reader = null;
            try {
                this.properties = new SortedProperties();
                if (this.propertiesFile.exists()) {
                    reader = new InputStreamReader((InputStream)new FileInputStream(this.propertiesFile), Charsets.UTF_8);
                    this.properties.load(reader);
                }
            }
            catch (IOException e) {
                throw new GradlePluginsRuntimeException(String.format("Cannot read preference from file %s", this.propertiesFile.getAbsolutePath()), e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        String readString(String key, String defaultValue) {
            return this.getProperties().getProperty(key, defaultValue);
        }

        @Override
        boolean readBoolean(String key, boolean defaultValue) {
            String value = this.getProperties().getProperty(key, null);
            return value == null ? defaultValue : Boolean.parseBoolean(value);
        }

        @Override
        void write(String key, String value) {
            if (value == null) {
                this.getProperties().remove(key);
            } else {
                this.getProperties().put(key, value);
            }
        }

        @Override
        void writeBoolean(String key, boolean value) {
            this.getProperties().put(key, String.valueOf(value));
        }

        @Override
        void flush() {
            this.properties.put("eclipse.preferences.version", "1");
            OutputStream output = null;
            try {
                if (!this.propertiesFile.exists()) {
                    this.propertiesFile.getParentFile().mkdirs();
                    Files.touch((File)this.propertiesFile);
                }
                output = new FileOutputStream(this.propertiesFile);
                output.write(PropertiesFilePreferenceStore.removeTimestampFromTable(this.properties).getBytes("UTF-8"));
                output.flush();
            }
            catch (IOException e) {
                throw new GradlePluginsRuntimeException(String.format("Cannot store preferences in file %s", this.propertiesFile.getAbsolutePath()), e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        protected static String removeTimestampFromTable(Properties properties) throws IOException {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                properties.store(output, null);
            }
            String string = output.toString("UTF-8");
            String separator = System.getProperty("line.separator");
            return string.substring(string.indexOf(separator) + separator.length());
        }
    }

    public class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Enumeration<Object> keys() {
            TreeSet<Object> set = new TreeSet<Object>();
            Enumeration<Object> e = super.keys();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            return Collections.enumeration(set);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            TreeSet<Map.Entry<Object, Object>> set = new TreeSet<Map.Entry<Object, Object>>(new Comparator<Map.Entry<Object, Object>>(){

                @Override
                public int compare(Map.Entry<Object, Object> e1, Map.Entry<Object, Object> e2) {
                    String s1 = (String)e1.getKey();
                    String s2 = (String)e2.getKey();
                    return s1.compareTo(s2);
                }
            });
            Iterator<Map.Entry<Object, Object>> i = super.entrySet().iterator();
            while (i.hasNext()) {
                set.add(i.next());
            }
            return set;
        }
    }
}

