/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.business.api.migration.AbstractMigrationParticipant;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.osgi.framework.Version;

public class FontFormatMigrationParticipant
extends AbstractMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("10.0.0.201505222000");
    private static final String ITALIC = "italic";
    private static final String BOLD = "bold";

    @Override
    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    @Override
    public Object getValue(EObject object, EStructuralFeature feature, Object value, String loadedVersion) {
        if (Version.parseVersion((String)loadedVersion).compareTo(MIGRATION_VERSION) < 0 && feature.getEType() == ViewpointPackage.Literals.FONT_FORMAT && value instanceof String) {
            ArrayList<FontFormat> labelFormat = new ArrayList<FontFormat>();
            String oldFontFormat = (String)value;
            if (oldFontFormat.contains(ITALIC)) {
                FontFormatHelper.setFontFormat(labelFormat, FontFormat.ITALIC_LITERAL);
            }
            if (oldFontFormat.contains(BOLD)) {
                FontFormatHelper.setFontFormat(labelFormat, FontFormat.BOLD_LITERAL);
            }
            if (FontFormat.get((String)((String)value)) != null) {
                FontFormatHelper.setFontFormat(labelFormat, FontFormat.get((String)((String)value)));
            }
            return ((Object)labelFormat).toString().replaceAll(",", "").replace("[", "").replace("]", "");
        }
        return null;
    }
}

