/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;

public final class DotFileUtils {
    private DotFileUtils() {
    }

    public static File resolve(URL url) {
        File resultFile = null;
        URL resolved = url;
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Unsupported protocol: " + url.getProtocol());
        }
        try {
            resultFile = new File(resolved.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return resultFile;
    }

    public static File write(String text) {
        try {
            return DotFileUtils.write(text, File.createTempFile("tmp", ".dot"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File write(String text, File destination) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destination), "UTF-8"));
            writer.write(text);
            writer.flush();
            writer.close();
            return destination;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String read(File file) {
        try {
            return DotFileUtils.read(new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String read(InputStream is) throws IOException {
        String lineSeparator = System.lineSeparator();
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = reader.readLine();
        while (line != null) {
            builder.append(line).append(lineSeparator);
            line = reader.readLine();
        }
        reader.close();
        return builder.toString();
    }
}

