/*
 * generated by Xtext 2.32.0
 */
package org.eclipse.gef.dot.internal.ui.language;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.gef.dot.internal.language.DotArrowTypeRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotColorListRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotColorRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotEscStringRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotFontNameRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotHtmlLabelRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotPointRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotPortPosRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotRecordLabelRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotRectRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotShapeRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotSplineTypeRuntimeModule;
import org.eclipse.gef.dot.internal.language.DotStyleRuntimeModule;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.util.Modules2;
import org.osgi.framework.BundleContext;

/**
 * This class was generated. Customizations should only happen in a newly
 * introduced subclass. 
 */
public class DotActivator extends AbstractUIPlugin {

	public static final String PLUGIN_ID = "org.eclipse.gef.dot.ui";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOT = "org.eclipse.gef.dot.internal.language.Dot";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTARROWTYPE = "org.eclipse.gef.dot.internal.language.DotArrowType";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTCOLOR = "org.eclipse.gef.dot.internal.language.DotColor";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTCOLORLIST = "org.eclipse.gef.dot.internal.language.DotColorList";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTESCSTRING = "org.eclipse.gef.dot.internal.language.DotEscString";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTFONTNAME = "org.eclipse.gef.dot.internal.language.DotFontName";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTHTMLLABEL = "org.eclipse.gef.dot.internal.language.DotHtmlLabel";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTPOINT = "org.eclipse.gef.dot.internal.language.DotPoint";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTPORTPOS = "org.eclipse.gef.dot.internal.language.DotPortPos";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTRECORDLABEL = "org.eclipse.gef.dot.internal.language.DotRecordLabel";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTRECT = "org.eclipse.gef.dot.internal.language.DotRect";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSHAPE = "org.eclipse.gef.dot.internal.language.DotShape";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSPLINETYPE = "org.eclipse.gef.dot.internal.language.DotSplineType";
	public static final String ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSTYLE = "org.eclipse.gef.dot.internal.language.DotStyle";
	
	private static final Logger logger = Logger.getLogger(DotActivator.class);
	
	private static DotActivator INSTANCE;
	
	private Map<String, Injector> injectors = Collections.synchronizedMap(Maps.<String, Injector> newHashMapWithExpectedSize(1));
	
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		INSTANCE = this;
	}
	
	@Override
	public void stop(BundleContext context) throws Exception {
		injectors.clear();
		INSTANCE = null;
		super.stop(context);
	}
	
	public static DotActivator getInstance() {
		return INSTANCE;
	}
	
	public Injector getInjector(String language) {
		synchronized (injectors) {
			Injector injector = injectors.get(language);
			if (injector == null) {
				injectors.put(language, injector = createInjector(language));
			}
			return injector;
		}
	}
	
	protected Injector createInjector(String language) {
		try {
			com.google.inject.Module runtimeModule = getRuntimeModule(language);
			com.google.inject.Module sharedStateModule = getSharedStateModule();
			com.google.inject.Module uiModule = getUiModule(language);
			com.google.inject.Module mergedModule = Modules2.mixin(runtimeModule, sharedStateModule, uiModule);
			return Guice.createInjector(mergedModule);
		} catch (Exception e) {
			logger.error("Failed to create injector for " + language);
			logger.error(e.getMessage(), e);
			throw new RuntimeException("Failed to create injector for " + language, e);
		}
	}
	
	protected com.google.inject.Module getRuntimeModule(String grammar) {
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOT.equals(grammar)) {
			return new DotRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTARROWTYPE.equals(grammar)) {
			return new DotArrowTypeRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTCOLOR.equals(grammar)) {
			return new DotColorRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTCOLORLIST.equals(grammar)) {
			return new DotColorListRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTESCSTRING.equals(grammar)) {
			return new DotEscStringRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTFONTNAME.equals(grammar)) {
			return new DotFontNameRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTHTMLLABEL.equals(grammar)) {
			return new DotHtmlLabelRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTPOINT.equals(grammar)) {
			return new DotPointRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTPORTPOS.equals(grammar)) {
			return new DotPortPosRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTRECORDLABEL.equals(grammar)) {
			return new DotRecordLabelRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTRECT.equals(grammar)) {
			return new DotRectRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSHAPE.equals(grammar)) {
			return new DotShapeRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSPLINETYPE.equals(grammar)) {
			return new DotSplineTypeRuntimeModule();
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSTYLE.equals(grammar)) {
			return new DotStyleRuntimeModule();
		}
		throw new IllegalArgumentException(grammar);
	}
	
	protected com.google.inject.Module getUiModule(String grammar) {
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOT.equals(grammar)) {
			return new DotUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTARROWTYPE.equals(grammar)) {
			return new DotArrowTypeUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTCOLOR.equals(grammar)) {
			return new DotColorUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTCOLORLIST.equals(grammar)) {
			return new DotColorListUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTESCSTRING.equals(grammar)) {
			return new DotEscStringUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTFONTNAME.equals(grammar)) {
			return new DotFontNameUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTHTMLLABEL.equals(grammar)) {
			return new DotHtmlLabelUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTPOINT.equals(grammar)) {
			return new DotPointUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTPORTPOS.equals(grammar)) {
			return new DotPortPosUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTRECORDLABEL.equals(grammar)) {
			return new DotRecordLabelUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTRECT.equals(grammar)) {
			return new DotRectUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSHAPE.equals(grammar)) {
			return new DotShapeUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSPLINETYPE.equals(grammar)) {
			return new DotSplineTypeUiModule(this);
		}
		if (ORG_ECLIPSE_GEF_DOT_INTERNAL_LANGUAGE_DOTSTYLE.equals(grammar)) {
			return new DotStyleUiModule(this);
		}
		throw new IllegalArgumentException(grammar);
	}
	
	protected com.google.inject.Module getSharedStateModule() {
		return new SharedStateModule();
	}
	
	
}
