/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.navigator.resources.actions.PasteAction;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;

class CopyAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.CopyAction";
    private final Shell shell;
    private final Clipboard clipboard;
    private PasteAction pasteAction;

    public CopyAction(Shell shell, Clipboard clipboard) {
        super(WorkbenchNavigatorMessages.CopyAction_Cop_);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(WorkbenchNavigatorMessages.CopyAction_Copy_selected_resource_s_);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "CopyHelpId");
    }

    public CopyAction(Shell shell, Clipboard clipboard, PasteAction pasteAction) {
        this(shell, clipboard);
        this.pasteAction = pasteAction;
    }

    public void run() {
        List selectedResources = this.getSelectedResources();
        IResource[] resources = selectedResources.toArray(new IResource[selectedResources.size()]);
        int length = resources.length;
        int actualLength = 0;
        String[] fileNames = new String[length];
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < length) {
            IPath location = resources[i].getLocation();
            if (location != null) {
                fileNames[actualLength++] = location.toOSString();
            }
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(resources[i].getName());
            ++i;
        }
        if (actualLength < length) {
            String[] tempFileNames = fileNames;
            fileNames = new String[actualLength];
            System.arraycopy(tempFileNames, 0, fileNames, 0, actualLength);
        }
        this.setClipboard(resources, fileNames, buf.toString());
        if (this.pasteAction != null && this.pasteAction.getStructuredSelection() != null) {
            this.pasteAction.selectionChanged(this.pasteAction.getStructuredSelection());
        }
    }

    private void setClipboard(IResource[] resources, String[] fileNames, String names) {
        block5: {
            try {
                if (fileNames.length > 0) {
                    this.clipboard.setContents(new Object[]{resources, fileNames, names}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else {
                    this.clipboard.setContents(new Object[]{resources, names}, new Transfer[]{ResourceTransfer.getInstance(), TextTransfer.getInstance()});
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.shell, (String)"Problem with copy title", (String)"Problem with copy.")) break block5;
                this.setClipboard(resources, fileNames, names);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.isEmpty()) {
            return false;
        }
        boolean projSelected = this.selectionIsOfType(4);
        boolean fileFoldersSelected = this.selectionIsOfType(3);
        if (!projSelected && !fileFoldersSelected) {
            return false;
        }
        if (projSelected && fileFoldersSelected) {
            return false;
        }
        IContainer firstParent = ((IResource)selectedResources.get(0)).getParent();
        if (firstParent == null) {
            return false;
        }
        for (IResource currentResource : selectedResources) {
            if (!currentResource.getParent().equals((Object)firstParent)) {
                return false;
            }
            if (currentResource.getLocationURI() != null) continue;
            return false;
        }
        return true;
    }
}

