/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.internal.policies.validators;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.resource.support.WorkspaceDragAndDropSupport;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementContainerWithInterpreterOperations;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.dnd.DragAndDropWrapper;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.DragSource;

public class DragAndDropValidator {
    private Set<DragAndDropWrapper> elementsFromEclipseViewToDrop = new HashSet<DragAndDropWrapper>();
    private Set<DDiagramElement> elementsFromDiagramToDrop = new HashSet<DDiagramElement>();
    private Set<IGraphicalEditPart> editPartsFromDiagramToDrop = new HashSet<IGraphicalEditPart>();
    private DragAndDropTarget targetDragAndDropTarget;
    private Session session;
    private EObject targetAbstractDNodeSemanticTarget;
    private DragAndDropTargetDescription dragAndDropDescription;
    private boolean isConcerningOnlyBorderNodeFromView;

    public boolean isValid(ChangeBoundsRequest request, GraphicalEditPart hostGraphicalEditPart) {
        boolean isValid = this.init(request, hostGraphicalEditPart);
        isValid = !this.elementsFromEclipseViewToDrop.isEmpty() || !this.elementsFromDiagramToDrop.isEmpty() ? isValid && "drop".equals(request.getType()) : false;
        if (isValid) {
            this.dragAndDropDescription = this.targetDragAndDropTarget.getDragAndDropDescription();
            boolean bl = isValid = isValid && this.targetDragAndDropTarget instanceof DSemanticDecorator;
            if (isValid) {
                this.targetAbstractDNodeSemanticTarget = ((DSemanticDecorator)this.targetDragAndDropTarget).getTarget();
                this.session = SessionManager.INSTANCE.getSession(this.targetAbstractDNodeSemanticTarget);
                isValid = this.dragAndDropDescription != null && this.targetAbstractDNodeSemanticTarget != null ? this.isValidDragAndDropRequestForElementFromEclipseView() && this.isValidDragAndDropRequestForElementFromDiagram() : false;
            }
        }
        return isValid;
    }

    private boolean init(ChangeBoundsRequest request, GraphicalEditPart hostGraphicalEditPart) {
        List editParts = request.getEditParts();
        EditPartQuery editPartQuery = new EditPartQuery((IGraphicalEditPart)hostGraphicalEditPart);
        boolean isInLayoutingMode = editPartQuery.isInLayoutingMode();
        boolean isInShowingMode = editPartQuery.isInShowingMode();
        for (Object editPart : editParts) {
            IGraphicalEditPart graphicalEditPartToDrop;
            if (editPart instanceof DragAndDropWrapper) {
                DragAndDropWrapper dragAndDropWrapperToDrop = (DragAndDropWrapper)((Object)editPart);
                this.elementsFromEclipseViewToDrop.add(dragAndDropWrapperToDrop);
                continue;
            }
            if (!(editPart instanceof IGraphicalEditPart) || editPart instanceof DNodeNameEditPart || (graphicalEditPartToDrop = (IGraphicalEditPart)editPart).getParent() == hostGraphicalEditPart || hostGraphicalEditPart instanceof CompartmentEditPart && graphicalEditPartToDrop.getParent() == hostGraphicalEditPart.getParent() || !(graphicalEditPartToDrop.resolveSemanticElement() instanceof DSemanticDecorator)) continue;
            EObject elementFromDiagramToDrop = graphicalEditPartToDrop.resolveSemanticElement();
            DDiagramElement dDiagramElementTopDrop = (DDiagramElement)elementFromDiagramToDrop;
            this.elementsFromDiagramToDrop.add(dDiagramElementTopDrop);
            this.editPartsFromDiagramToDrop.add(graphicalEditPartToDrop);
            if (!isInLayoutingMode && !isInShowingMode || !(graphicalEditPartToDrop instanceof IAbstractDiagramNodeEditPart)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDragAndDropRequestForElementFromEclipseView() {
        boolean isValidDragAndDropRequestForElementFromEclipseView = true;
        Iterator<DragAndDropWrapper> iterator = this.elementsFromEclipseViewToDrop.iterator();
        if (iterator.hasNext()) {
            this.isConcerningOnlyBorderNodeFromView = true;
        }
        while (iterator.hasNext() && isValidDragAndDropRequestForElementFromEclipseView) {
            DragAndDropWrapper elementFromEclipseViewToDrop = iterator.next();
            if (!(elementFromEclipseViewToDrop.getObject() instanceof IStructuredSelection)) continue;
            IStructuredSelection structuredSelection = (IStructuredSelection)elementFromEclipseViewToDrop.getObject();
            for (Object object : structuredSelection.toList()) {
                EObject droppedElementForDropTool = new WorkspaceDragAndDropSupport().convert(object, this.session);
                boolean bl = isValidDragAndDropRequestForElementFromEclipseView = isValidDragAndDropRequestForElementFromEclipseView && droppedElementForDropTool != null;
                if (!isValidDragAndDropRequestForElementFromEclipseView) continue;
                ContainerDropDescription containerDropDescription = DDiagramElementContainerWithInterpreterOperations.getBestDropDescription((DragAndDropTargetDescription)this.dragAndDropDescription, (EObject)droppedElementForDropTool, null, (EObject)this.targetAbstractDNodeSemanticTarget, (EObject)this.targetDragAndDropTarget, (DragSource)DragSource.PROJECT_EXPLORER_LITERAL, null);
                boolean bl2 = isValidDragAndDropRequestForElementFromEclipseView = containerDropDescription != null;
                if (isValidDragAndDropRequestForElementFromEclipseView) {
                    for (DiagramElementMapping diagramElementMapping : containerDropDescription.getMappings()) {
                        if (DescriptionPackage.eINSTANCE.getAbstractNodeMapping_BorderedNodeMappings().equals(diagramElementMapping.eContainingFeature())) continue;
                        this.isConcerningOnlyBorderNodeFromView = false;
                    }
                    continue;
                }
                this.isConcerningOnlyBorderNodeFromView = false;
            }
        }
        return isValidDragAndDropRequestForElementFromEclipseView;
    }

    public boolean isConcerningOnlyBorderNodeFromView() {
        return this.isConcerningOnlyBorderNodeFromView;
    }

    private boolean isValidDragAndDropRequestForElementFromDiagram() {
        boolean isValidDragAndDropRequestForElementFromDiagram = true;
        Iterator<DDiagramElement> iterator = this.elementsFromDiagramToDrop.iterator();
        while (iterator.hasNext() && isValidDragAndDropRequestForElementFromDiagram) {
            DDiagramElement elementFromDiagramToDrop = iterator.next();
            boolean bl = isValidDragAndDropRequestForElementFromDiagram = isValidDragAndDropRequestForElementFromDiagram && elementFromDiagramToDrop != null;
            if (!isValidDragAndDropRequestForElementFromDiagram) continue;
            ContainerDropDescription containerDropDescription = DDiagramElementContainerWithInterpreterOperations.getBestDropDescription((DragAndDropTargetDescription)this.dragAndDropDescription, (EObject)elementFromDiagramToDrop.getTarget(), (EObject)this.getSemanticContainer(elementFromDiagramToDrop), (EObject)this.targetAbstractDNodeSemanticTarget, (EObject)this.targetDragAndDropTarget, (DragSource)DragSource.DIAGRAM_LITERAL, (EObject)elementFromDiagramToDrop);
            boolean bl2 = isValidDragAndDropRequestForElementFromDiagram = containerDropDescription != null;
        }
        return isValidDragAndDropRequestForElementFromDiagram;
    }

    private EObject getSemanticContainer(DDiagramElement diagramElement) {
        EObject semanticContainer = null;
        EObject current = diagramElement.eContainer();
        while (current != null && semanticContainer == null) {
            if (current instanceof DSemanticDecorator) {
                semanticContainer = ((DSemanticDecorator)current).getTarget();
            }
            current = current.eContainer();
        }
        return semanticContainer;
    }

    public void setTargetDragAndDropTarget(DragAndDropTarget targetDragAndDropTarget) {
        this.targetDragAndDropTarget = targetDragAndDropTarget;
    }

    public DragAndDropTargetDescription getDragDragAndDropDescription() {
        return this.dragAndDropDescription;
    }

    public EObject getTargetAbstractDNodeSemanticTarget() {
        return this.targetAbstractDNodeSemanticTarget;
    }

    public Set<DragAndDropWrapper> getElementsFromEclipseViewToDrop() {
        return this.elementsFromEclipseViewToDrop;
    }

    public Set<DDiagramElement> getElementsFromDiagramToDrop() {
        return this.elementsFromDiagramToDrop;
    }

    public Set<IGraphicalEditPart> getEditPartsFromDiagramToDrop() {
        return this.editPartsFromDiagramToDrop;
    }
}

