/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.dialogs;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.IEnumLabel;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.dialogs.AbstractSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;

public class CircularSeriesSettingsDialog
extends AbstractSeriesSettingsDialog<ICircularSeriesSettings> {
    private AtomicReference<Text> sliceColorControl = new AtomicReference();
    private AtomicReference<Text> borderColorControl = new AtomicReference();
    private AtomicReference<Spinner> borderWidthControl = new AtomicReference();
    private AtomicReference<ComboViewer> borderStyleControl = new AtomicReference();

    public CircularSeriesSettingsDialog(Shell parentShell, ICircularSeriesSettings settings) {
        super(parentShell, settings);
    }

    @Override
    protected void createInputSection(Composite parent) {
        super.createInputSection(parent);
        this.createSliceColorSection(parent);
        this.createBorderColorSection(parent);
        this.createBorderWidthSection(parent);
        this.createBorderStyleSection(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        ICircularSeriesSettings settings = (ICircularSeriesSettings)this.getSettings();
        if (settings != null) {
            this.sliceColorControl.get().setBackground(settings.getSliceColor());
            this.borderColorControl.get().setBackground(settings.getBorderColor());
            this.borderWidthControl.get().setSelection(settings.getBorderWidth());
            this.borderStyleControl.get().setSelection((ISelection)new StructuredSelection((Object)settings.getBorderStyle()));
        }
    }

    private void createSliceColorSection(Composite parent) {
        String title = "Slice Color";
        this.createSectionLabel(parent, title);
        Text text = this.createColorChoser(parent, title, this.getGridData(768, 1), new Consumer<Color>(){

            @Override
            public void accept(Color color) {
                ICircularSeriesSettings settings = (ICircularSeriesSettings)CircularSeriesSettingsDialog.this.getSettings();
                if (settings != null) {
                    settings.setSliceColor(color);
                }
            }
        });
        this.sliceColorControl.set(text);
    }

    private void createBorderColorSection(Composite parent) {
        String title = "Border Color";
        this.createSectionLabel(parent, title);
        Text text = this.createColorChoser(parent, title, this.getGridData(768, 1), new Consumer<Color>(){

            @Override
            public void accept(Color color) {
                ICircularSeriesSettings settings = (ICircularSeriesSettings)CircularSeriesSettingsDialog.this.getSettings();
                if (settings != null) {
                    settings.setBorderColor(color);
                }
            }
        });
        this.borderColorControl.set(text);
    }

    private void createBorderWidthSection(Composite parent) {
        String title = "Border Width";
        this.createSectionLabel(parent, title);
        Spinner spinner = this.createSpinner(parent, title, 1, 50, 1, this.getGridData(768, 2), new Consumer<Integer>(){

            @Override
            public void accept(Integer selection) {
                ICircularSeriesSettings settings = (ICircularSeriesSettings)CircularSeriesSettingsDialog.this.getSettings();
                if (settings != null) {
                    settings.setBorderWidth(selection);
                }
            }
        });
        this.borderWidthControl.set(spinner);
    }

    private void createBorderStyleSection(Composite parent) {
        String title = "Border Style";
        this.createSectionLabel(parent, title);
        ComboViewer comboViewer = this.createComboViewer(parent, title, (IEnumLabel[])LineStyle.values(), LineStyle.NONE, this.getGridData(768, 2), new Consumer<Object>(){

            @Override
            public void accept(Object object) {
                ICircularSeriesSettings settings = (ICircularSeriesSettings)CircularSeriesSettingsDialog.this.getSettings();
                if (settings != null && object instanceof LineStyle) {
                    settings.setBorderStyle((LineStyle)object);
                }
            }
        });
        this.borderStyleControl.set(comboViewer);
    }
}

