/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.asm;

import org.eclipse.cdt.internal.ui.text.BufferedDocumentScanner;
import org.eclipse.cdt.ui.text.ICPartitions;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public final class AsmPartitionScanner
implements IPartitionTokenScanner,
ICPartitions {
    private static final String NON_LINE_COMMENT_CHARS = "\t #/_$.%()'\"{}";
    private static final String KNOWN_LINE_END_COMMENT_CHARS = "#;@|!";
    private static final int CCODE = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int CHARACTER = 3;
    private static final int STRING = 4;
    private static final int PREPROCESSOR = 5;
    private static final int PREPROCESSOR_MULTI_LINE_COMMENT = 6;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int SLASH = 2;
    private static final int SLASH_STAR = 3;
    private static final int STAR = 4;
    private static final int CARRIAGE_RETURN = 5;
    private static final int BACKSLASH_CR = 6;
    private static final int BACKSLASH_BACKSLASH = 7;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private boolean fFirstCharOnLine = true;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__c_singleline_comment"), new Token((Object)"__c_multiline_comment"), new Token((Object)"__c_character"), new Token((Object)"__c_string"), new Token((Object)"__c_preprocessor"), new Token((Object)"__c_multiline_comment")};
    private String fLineCommentChars = "";
    private String fLineEndCommentChars = "";
    private String fLineStartCommentChars = ";!|@";
    private boolean fDetectPreprocessor = true;

    public void setLineCommentCharacters(String chars) {
        this.fLineCommentChars = chars != null ? chars : "";
    }

    public void setLineStartCommentCharacters(String chars) {
        this.fLineStartCommentChars = chars != null ? chars : "";
    }

    public void setLineEndCommentCharacters(String chars) {
        this.fLineEndCommentChars = chars != null ? chars : "";
    }

    public void setDetectPreprocessorDiretives(boolean detectPreprocessor) {
        this.fDetectPreprocessor = detectPreprocessor;
    }

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        block63: while (true) {
            int ch = this.fScanner.read();
            boolean isFirstCharOnLine = this.fFirstCharOnLine;
            if (this.fFirstCharOnLine && ch != 32 && ch != 9) {
                this.fFirstCharOnLine = false;
            }
            switch (ch) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 13: {
                    this.fFirstCharOnLine = true;
                    if (this.fLast == 1 || this.fLast == 7) {
                        this.fLast = 6;
                        ++this.fTokenLength;
                        continue block63;
                    }
                    if (this.fLast != 5) {
                        this.fLast = 5;
                        ++this.fTokenLength;
                        continue block63;
                    }
                    switch (this.fState) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (this.fTokenLength > 0) {
                                IToken token = this.fTokens[this.fState];
                                this.fLast = 5;
                                this.fPrefixLength = 1;
                                this.fState = 0;
                                return token;
                            }
                            this.consume();
                            continue block63;
                        }
                    }
                    this.consume();
                    continue block63;
                }
                case 92: {
                    switch (this.fState) {
                        case 3: 
                        case 4: {
                            ++this.fTokenLength;
                            this.fLast = this.fLast == 1 ? 7 : 1;
                            continue block63;
                        }
                    }
                    ++this.fTokenLength;
                    this.fLast = 1;
                    continue block63;
                }
                case 10: {
                    this.fFirstCharOnLine = true;
                    switch (this.fState) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (this.fLast != 1 && this.fLast != 6 && this.fLast != 7) {
                                return this.postFix(this.fState);
                            }
                            this.consume();
                            continue block63;
                        }
                    }
                    this.consume();
                    continue block63;
                }
                case 9: 
                case 32: {
                    this.consume();
                    continue block63;
                }
            }
            if (this.fLast == 5) {
                switch (this.fState) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int last;
                        int newState = switch (ch) {
                            case 47 -> {
                                last = 2;
                                yield 0;
                            }
                            case 42 -> {
                                last = 4;
                                yield 0;
                            }
                            case 39 -> {
                                last = 0;
                                yield 3;
                            }
                            case 34 -> {
                                last = 0;
                                yield 4;
                            }
                            case 13 -> {
                                last = 5;
                                yield 0;
                            }
                            case 92 -> {
                                last = 1;
                                yield 0;
                            }
                            case 35 -> {
                                last = 0;
                                yield 5;
                            }
                            default -> {
                                last = 0;
                                yield 0;
                            }
                        };
                        this.fLast = 0;
                        return this.preFix(this.fState, newState, last, 1);
                    }
                    case 0: {
                        if (!this.fDetectPreprocessor || ch != 35 || !isFirstCharOnLine) break;
                        this.fLast = 0;
                        int column = this.fScanner.getColumn() - 1;
                        this.fTokenLength -= column;
                        if (this.fTokenLength > 0) {
                            return this.preFix(this.fState, 5, 0, column + 1);
                        }
                        this.preFix(this.fState, 5, 0, column + 1);
                        this.fTokenOffset += this.fTokenLength;
                        this.fTokenLength = this.fPrefixLength;
                        break;
                    }
                }
            }
            switch (this.fState) {
                case 0: {
                    if (this.fLast == 0) {
                        boolean isLineComment = false;
                        if (ch != 35 || !this.fDetectPreprocessor || !isFirstCharOnLine) {
                            if (this.fLineCommentChars.indexOf(ch) >= 0 || isFirstCharOnLine && this.fLineStartCommentChars.indexOf(ch) >= 0 || !isFirstCharOnLine && this.fLineEndCommentChars.indexOf(ch) >= 0) {
                                isLineComment = true;
                            } else if (isFirstCharOnLine && !Character.isLetterOrDigit((char)ch) && NON_LINE_COMMENT_CHARS.indexOf(ch) < 0) {
                                this.fLineStartCommentChars = String.valueOf(this.fLineStartCommentChars) + (char)ch;
                                isLineComment = true;
                            }
                        }
                        if (isLineComment) {
                            if (isFirstCharOnLine && this.fLineEndCommentChars.indexOf(ch) < 0 && KNOWN_LINE_END_COMMENT_CHARS.indexOf(ch) >= 0) {
                                this.fLineEndCommentChars = String.valueOf(this.fLineEndCommentChars) + (char)ch;
                            }
                            if (this.fTokenLength - AsmPartitionScanner.getLastLength(this.fLast) > 0) {
                                return this.preFix(0, 1, 0, 1);
                            }
                            this.preFix(0, 1, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            continue block63;
                        }
                    }
                    switch (ch) {
                        case 47: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - AsmPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 1, 0, 2);
                                }
                                this.preFix(0, 1, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                continue block63;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            continue block63;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - AsmPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 2, 3, 2);
                                }
                                this.preFix(0, 2, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                continue block63;
                            }
                            this.consume();
                            continue block63;
                        }
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 3, 0, 1);
                            }
                            this.preFix(0, 3, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            continue block63;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            continue block63;
                        }
                        case 35: {
                            if (this.fDetectPreprocessor && isFirstCharOnLine) {
                                int column = this.fScanner.getColumn() - 1;
                                this.fTokenLength -= column;
                                if (this.fTokenLength > 0) {
                                    return this.preFix(this.fState, 5, 0, column + 1);
                                }
                                this.preFix(this.fState, 5, 0, column + 1);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                continue block63;
                            }
                            this.consume();
                            continue block63;
                        }
                    }
                    this.consume();
                    continue block63;
                }
                case 1: {
                    this.consume();
                    continue block63;
                }
                case 5: {
                    switch (ch) {
                        case 47: {
                            if (this.fLast == 2) {
                                this.consume();
                                continue block63;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            continue block63;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - AsmPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(this.fState, 6, 3, 2);
                                }
                                this.preFix(this.fState, 6, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                continue block63;
                            }
                            this.consume();
                            continue block63;
                        }
                    }
                    this.consume();
                    continue block63;
                }
                case 6: {
                    switch (ch) {
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 4;
                            continue block63;
                        }
                        case 47: {
                            if (this.fLast == 4) {
                                IToken token = this.postFix(this.fState);
                                this.fState = 5;
                                return token;
                            }
                            this.consume();
                            continue block63;
                        }
                    }
                    this.consume();
                    continue block63;
                }
                case 2: {
                    switch (ch) {
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 4;
                            continue block63;
                        }
                        case 47: {
                            if (this.fLast == 4) {
                                return this.postFix(2);
                            }
                            this.consume();
                            continue block63;
                        }
                    }
                    this.consume();
                    continue block63;
                }
                case 4: {
                    switch (ch) {
                        case 34: {
                            if (this.fLast != 1) {
                                return this.postFix(4);
                            }
                            this.consume();
                            continue block63;
                        }
                    }
                    this.consume();
                    continue block63;
                }
                case 3: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            if (this.fLast == 1) continue block63;
                            return this.preFix(3, 0, 0, 1);
                        }
                    }
                    return this.postFix(3);
                }
            }
        }
    }

    private static final int getLastLength(int last) {
        switch (last) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
            case 3: 
            case 6: 
            case 7: 
        }
        return 2;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int state) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[state];
    }

    private final IToken preFix(int state, int newState, int last, int prefixLength) {
        this.fTokenLength -= AsmPartitionScanner.getLastLength(this.fLast);
        this.fLast = last;
        this.fPrefixLength = prefixLength;
        IToken token = this.fTokens[state];
        this.fState = newState;
        return token;
    }

    private static int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType.equals("__c_singleline_comment")) {
            return 1;
        }
        if (contentType.equals("__c_multiline_comment")) {
            return 2;
        }
        if (contentType.equals("__c_string")) {
            return 4;
        }
        if (contentType.equals("__c_character")) {
            return 3;
        }
        if (contentType.equals("__c_preprocessor")) {
            return 5;
        }
        return 0;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = 0;
        this.fState = offset == partitionOffset ? 0 : AsmPartitionScanner.getState(contentType);
        try {
            int column = this.fScanner.getColumn();
            this.fFirstCharOnLine = column == 0 || document.get(offset - column, column).trim().length() == 0;
        }
        catch (BadLocationException exc) {
            this.fFirstCharOnLine = true;
        }
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
        try {
            int column = this.fScanner.getColumn();
            this.fFirstCharOnLine = column == 0 || document.get(offset - column, column).trim().length() == 0;
        }
        catch (BadLocationException exc) {
            this.fFirstCharOnLine = true;
        }
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

