/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.resources.actions.OpenFolderAsProjectAction;
import org.eclipse.ui.internal.navigator.resources.actions.SelectProjectForFolderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class FoldersAsProjectsActionProvider
extends CommonActionProvider {
    private CommonViewer viewer;

    public void init(ICommonActionExtensionSite aSite) {
        this.viewer = (CommonViewer)aSite.getStructuredViewer();
    }

    public void fillContextMenu(IMenuManager aMenu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Map<IPath, IProject> projects = this.projectsMap();
        LinkedList<IProject> existing = new LinkedList<IProject>();
        LinkedList<IFolder> nonexisting = new LinkedList<IFolder>();
        for (Object object : selection) {
            IFolder folder = (IFolder)Adapters.adapt(object, IFolder.class);
            if (folder == null) {
                return;
            }
            if (!folder.getFile(".project").exists()) {
                return;
            }
            if (projects.get(folder.getLocation()) != null) {
                existing.add(projects.get(folder.getLocation()));
            } else {
                nonexisting.add(folder);
            }
            if (existing.size() <= 0 || nonexisting.size() <= 0) continue;
            return;
        }
        if (existing.size() > 0) {
            action = new SelectProjectForFolderAction(existing, this.viewer);
            aMenu.appendToGroup("group.open", (IAction)action);
        } else {
            action = new OpenFolderAsProjectAction(nonexisting, this.viewer);
            aMenu.prependToGroup("group.port", (IAction)action);
        }
    }

    private Map<IPath, IProject> projectsMap() {
        return Stream.of(ResourcesPlugin.getWorkspace().getRoot().getProjects()).collect(Collectors.toMap(IResource::getLocation, self -> self));
    }
}

