/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.editor;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CMImageUtil {
    public static String SMALL_ICON_URL = "small-icon";

    public static CMNode getDeclaration(Node node) {
        CMAttributeDeclaration decl = null;
        ModelQuery mq = null;
        switch (node.getNodeType()) {
            case 2: {
                mq = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
                decl = mq.getCMAttributeDeclaration((Attr)node);
                break;
            }
            case 1: {
                mq = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
                decl = mq.getCMElementDeclaration((Element)node);
            }
        }
        return decl;
    }

    public static Image getImage(CMNode cmnode) {
        ImageDescriptor imageDescriptor;
        if (cmnode == null) {
            return null;
        }
        Image image = null;
        String imageURLString = (String)cmnode.getProperty(SMALL_ICON_URL);
        if (imageURLString != null && imageURLString.length() > 0 && (imageDescriptor = CMImageUtil.getImageDescriptor(imageURLString)) != null) {
            image = CMImageUtil.getImageRegistry().get(imageURLString);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(CMNode cmnode) {
        if (cmnode == null) {
            return null;
        }
        String imageURLString = (String)cmnode.getProperty(SMALL_ICON_URL);
        ImageDescriptor descriptor = null;
        if (imageURLString != null && imageURLString.length() > 0) {
            descriptor = CMImageUtil.getImageDescriptor(imageURLString.trim());
        }
        return descriptor;
    }

    private static ImageDescriptor getImageDescriptor(String imageURLString) {
        ImageDescriptor descriptor = CMImageUtil.getImageRegistry().getDescriptor(imageURLString);
        if (descriptor == null) {
            try {
                URL imageURL = new URL(imageURLString);
                if (imageURL != null) {
                    descriptor = ImageDescriptor.createFromURL((URL)imageURL);
                    CMImageUtil.getImageRegistry().put(imageURLString, descriptor);
                }
            }
            catch (MalformedURLException e) {
                Logger.logException(e);
            }
        }
        return descriptor;
    }

    private static final ImageRegistry getImageRegistry() {
        return XMLUIPlugin.getInstance().getImageRegistry();
    }

    private CMImageUtil() {
    }
}

