/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;
import org.eclipse.ui.IMemento;

public class SortCriterion {
    private static final String MEMENTO_KEY_SORT_KEY = "sortKey";
    private static final String MEMENTO_KEY_SORT_DIRECTION = "sortDirection";
    private static final SortKey DEFAULT_SORT_KIND = SortKey.NONE;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private static final int DEFAULT_SORT_DIRECTION = 1;
    public static final int kindCount = SortKey.values().length - 1;
    private SortKey key;
    private int direction;

    public SortCriterion() {
        this.key = DEFAULT_SORT_KIND;
        this.direction = 1;
    }

    public SortCriterion(SortKey kind, int sortDirection) {
        this.key = kind;
        this.direction = sortDirection;
    }

    public SortKey getKey() {
        return this.key;
    }

    public void setKey(SortKey kind) {
        Assert.isNotNull((Object)((Object)kind));
        this.key = kind;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int sortDirection) {
        Assert.isTrue((sortDirection == -1 || sortDirection == 1 ? 1 : 0) != 0);
        this.direction = sortDirection;
    }

    private SortKey getSortKey(IMemento memento, String key, SortKey defaultValue) {
        String value = memento.getString(key);
        if (value != null) {
            try {
                return SortKey.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private int getSortDirection(IMemento memento, String key, int defaultValue) {
        Integer value = memento.getInteger(key);
        if (value != null) {
            return value >= 0 ? 1 : -1;
        }
        return defaultValue;
    }

    public void restoreState(IMemento memento) {
        this.setKey(this.getSortKey(memento, MEMENTO_KEY_SORT_KEY, DEFAULT_SORT_KIND));
        this.setDirection(this.getSortDirection(memento, MEMENTO_KEY_SORT_DIRECTION, 1));
    }

    public void saveState(IMemento memento) {
        memento.putString(MEMENTO_KEY_SORT_KEY, this.getKey().name());
        memento.putInteger(MEMENTO_KEY_SORT_DIRECTION, this.getDirection());
    }

    public static enum SortKey {
        NONE,
        DATE_CREATED,
        PRIORITY,
        RANK,
        SUMMARY,
        TASK_ID,
        TASK_TYPE,
        DUE_DATE,
        MODIFICATION_DATE,
        SCHEDULED_DATE;


        public static SortKey valueOfLabel(String label) {
            SortKey[] sortKeyArray = SortKey.values();
            int n = sortKeyArray.length;
            int n2 = 0;
            while (n2 < n) {
                SortKey value = sortKeyArray[n2];
                if (value.getLabel().equals(label)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        public String getLabel() {
            return switch (this) {
                case NONE -> Messages.SortKindEntry_None;
                case PRIORITY -> Messages.SortKindEntry_Priority;
                case SUMMARY -> Messages.SortKindEntry_Summary;
                case RANK -> Messages.SortKindEntry_Rank;
                case DATE_CREATED -> Messages.SortKindEntry_Date_Created;
                case TASK_ID -> Messages.SortKindEntry_Task_ID;
                case TASK_TYPE -> Messages.SortCriterion_Type;
                case DUE_DATE -> Messages.SortKindEntry_Due_Date;
                case MODIFICATION_DATE -> Messages.SortCriterion_Modification_Date;
                case SCHEDULED_DATE -> Messages.SortCriterion_Scheduled_Date;
                default -> null;
            };
        }
    }
}

