/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder;

import javax.lang.model.SourceVersion;
import org.eclipse.mylyn.wikitext.parser.builder.UriProcessor;

public class JavadocShortcutUriProcessor
implements UriProcessor {
    private static final String TARGET = "_javadoc";
    private static final String JAVADOC_URI_MARKER = "@";
    private static final String JAVADOC_ABSOLUTE_URI_MARKER = "javadoc://";
    private static final String BASE_PACKAGE_MARKER = ".";
    private final String basePackageName;
    private final String javadocRelativePath;

    public JavadocShortcutUriProcessor(String javadocRelativePath, String basePackageName) {
        this.javadocRelativePath = javadocRelativePath;
        this.basePackageName = basePackageName;
    }

    @Override
    public String process(String uri) {
        String newUri = this.preprocessUri(uri);
        if (!newUri.equals(uri) && SourceVersion.isName(newUri = this.prependWithBasePackage(newUri))) {
            if (this.isPotentialPackageName(newUri)) {
                return this.toPackagePage(newUri);
            }
            return this.toTypePage(newUri);
        }
        return uri;
    }

    @Override
    public String target(String uri) {
        if (!this.preprocessUri(uri).equals(uri)) {
            return TARGET;
        }
        return null;
    }

    private String preprocessUri(String uri) {
        String newUri = uri;
        if (newUri.startsWith(JAVADOC_ABSOLUTE_URI_MARKER) && newUri.length() > JAVADOC_ABSOLUTE_URI_MARKER.length()) {
            newUri = newUri.substring(JAVADOC_ABSOLUTE_URI_MARKER.length());
        }
        if (newUri.startsWith(JAVADOC_URI_MARKER) && newUri.length() > JAVADOC_URI_MARKER.length()) {
            newUri = uri.substring(JAVADOC_URI_MARKER.length());
        }
        return newUri;
    }

    private String toTypePage(String newUri) {
        return this.javadocFramePage() + "?" + newUri.replace('.', '/') + ".html";
    }

    private String toPackagePage(String newUri) {
        return this.javadocFramePage() + "?" + newUri.replace('.', '/') + "/package-summary.html";
    }

    private String javadocFramePage() {
        if (this.javadocRelativePath == null) {
            return "index.html";
        }
        Object pageUri = this.javadocRelativePath;
        if (!((String)pageUri).endsWith("/")) {
            pageUri = (String)pageUri + "/";
        }
        return (String)pageUri + "index.html";
    }

    private String prependWithBasePackage(String uri) {
        if (uri.startsWith(BASE_PACKAGE_MARKER) && this.basePackageName != null) {
            return this.basePackageName + uri;
        }
        return uri;
    }

    private boolean isPotentialPackageName(String newUri) {
        int x = 0;
        while (x < newUri.length()) {
            char c = newUri.charAt(x);
            if (Character.isUpperCase(c)) {
                return false;
            }
            ++x;
        }
        return true;
    }
}

