/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.egit.ui.internal.history.RefFilterHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ViewSettingsDialog;

public class GitHistoryRefFilterConfigurationDialog
extends ViewSettingsDialog {
    private static final int EDITOR_ACTIVATION_KEY = 0x100000B;
    private static final String FILTER_COLUMN_NAME = "filter";
    private static final String NEW_FILTER_INITIAL_STRING = "refs/*";
    private final Repository repo;
    private final RefFilterHelper helper;
    private Set<RefFilterHelper.RefFilter> filters;
    private CheckboxTableViewer configsTable;
    private Button removeButton;
    private Button editButton;
    private TextCellEditor editor;
    private CLabel message;
    private boolean defaultsPerformed;
    private Point minimumSize;
    private Set<String> predefinedPatterns;

    public GitHistoryRefFilterConfigurationDialog(Shell parentShell, Repository repo, RefFilterHelper helper) {
        super(parentShell);
        this.repo = repo;
        this.helper = helper;
    }

    protected void configureShell(final Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.GitHistoryPage_filterRefDialog_dialogTitle);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                newShell.removeShellListener((ShellListener)this);
                if (GitHistoryRefFilterConfigurationDialog.this.minimumSize != null) {
                    newShell.setMinimumSize(GitHistoryRefFilterConfigurationDialog.this.minimumSize);
                }
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = this.createUi(parent);
        this.init();
        return container;
    }

    private Composite createUi(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setFont(parent.getFont());
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(container.getBackground());
        this.message = new CLabel(composite, 64);
        this.message.setText(UIText.GitHistoryPage_filterRefDialog_dialogMessage);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.message);
        Group filtersComposite = new Group(composite, 0);
        filtersComposite.setText(UIText.GitHistoryPage_filterRefDialog_filtersCompositeLabel);
        filtersComposite.setLayout((Layout)new GridLayout(2, false));
        filtersComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        filtersComposite.setBackground(composite.getBackground());
        this.fillFiltersComposite(filtersComposite);
        Composite actionsComposite = new Composite(composite, 0);
        actionsComposite.setLayout((Layout)new GridLayout());
        actionsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        actionsComposite.setBackground(composite.getBackground());
        this.createActionCompositeButtons(actionsComposite);
        composite.pack();
        this.minimumSize = composite.getSize();
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return container;
    }

    private void fillFiltersComposite(Group filtersComposite) {
        Composite tableComposite = new Composite((Composite)filtersComposite, 0);
        tableComposite.setLayout((Layout)new GridLayout());
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setBackground(filtersComposite.getBackground());
        this.createTable(tableComposite);
        tableComposite.pack();
        this.createFilterCompositeButtons((Composite)filtersComposite);
        Label patternExplanation = new Label((Composite)filtersComposite, 64);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = tableComposite.getSize().x;
        patternExplanation.setLayoutData((Object)data);
        patternExplanation.setText(UIText.GitHistoryPage_filterRefDialog_patternExplanation);
    }

    private void createTable(Composite parent) {
        this.configsTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)67586);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.widthHint = this.convertHorizontalDLUsToPixels(120);
        this.configsTable.getControl().setLayoutData((Object)tableData);
        this.configsTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.configsTable.setLabelProvider((IBaseLabelProvider)new RefLabelProvider());
        this.configsTable.setComparator(new ViewerComparator(){

            public int category(Object element) {
                RefFilterHelper.RefFilter filter = (RefFilterHelper.RefFilter)element;
                if (filter.isPreconfigured()) {
                    return 100;
                }
                return 1000;
            }
        });
        this.configsTable.addSelectionChangedListener(event -> this.updateButtonEnablement());
        this.configsTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((RefFilterHelper.RefFilter)event.getElement()).setSelected(event.getChecked());
            }
        });
        this.configsTable.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ((RefFilterHelper.RefFilter)element).isSelected();
            }
        });
        this.configsTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 && GitHistoryRefFilterConfigurationDialog.this.removeButton.isEnabled()) {
                    GitHistoryRefFilterConfigurationDialog.this.removeSelectedFilters();
                }
            }
        });
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager((TableViewer)this.configsTable, new FocusCellHighlighter((ColumnViewer)this.configsTable){});
        ColumnViewerEditorActivationStrategy editorActivation = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.configsTable){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                boolean isLeftDoubleClick;
                boolean singleSelect = GitHistoryRefFilterConfigurationDialog.this.configsTable.getStructuredSelection().size() == 1;
                boolean bl = isLeftDoubleClick = event.eventType == 3 && ((MouseEvent)event.sourceEvent).button == 1;
                return singleSelect && (isLeftDoubleClick || event.eventType == 4 || event.eventType == 1 && event.keyCode == 0x100000B);
            }
        };
        TableViewerEditor.create((TableViewer)this.configsTable, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)editorActivation, (int)33);
        this.editor = new TextCellEditor((Composite)this.configsTable.getTable()){

            protected Control createControl(Composite containing) {
                Control result = super.createControl(containing);
                if ((this.text.getStyle() & 4) != 0) {
                    this.text.addVerifyListener(event -> {
                        String string = event.text = Utils.firstLine((String)event.text);
                    });
                }
                return result;
            }
        };
        this.editor.setValidator(value -> {
            String currentText = value.toString().trim();
            if (currentText.isEmpty()) {
                return UIText.GitHistoryPage_filterRefDialog_refEmptyError;
            }
            if (this.predefinedPatterns.contains(currentText)) {
                return MessageFormat.format(UIText.GitHistoryPage_filterRefDialog_refPredefinedPattern, currentText);
            }
            return null;
        });
        this.editor.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (newValidState) {
                    GitHistoryRefFilterConfigurationDialog.this.setMessage(null);
                } else {
                    GitHistoryRefFilterConfigurationDialog.this.setMessage(GitHistoryRefFilterConfigurationDialog.this.editor.getErrorMessage());
                }
                GitHistoryRefFilterConfigurationDialog.this.getButton(0).setEnabled(newValidState);
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
            }
        });
        this.configsTable.getColumnViewerEditor().addEditorActivationListener(new ColumnViewerEditorActivationListener(){

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
                GitHistoryRefFilterConfigurationDialog.this.configsTable.reveal(GitHistoryRefFilterConfigurationDialog.this.configsTable.getStructuredSelection().getFirstElement());
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                GitHistoryRefFilterConfigurationDialog.this.setMessage(null);
                GitHistoryRefFilterConfigurationDialog.this.updateButtonEnablement();
                GitHistoryRefFilterConfigurationDialog.this.getButton(0).setEnabled(true);
            }
        });
        this.configsTable.setColumnProperties(new String[]{FILTER_COLUMN_NAME});
        this.configsTable.setCellEditors(new CellEditor[]{this.editor});
        this.configsTable.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                RefFilterHelper.RefFilter filter = (RefFilterHelper.RefFilter)((TableItem)element).getData();
                GitHistoryRefFilterConfigurationDialog.this.filters.remove(filter);
                filter.setFilterString((String)value);
                GitHistoryRefFilterConfigurationDialog.this.filters.add(filter);
                GitHistoryRefFilterConfigurationDialog.this.configsTable.refresh();
                GitHistoryRefFilterConfigurationDialog.this.configsTable.reveal((Object)filter);
            }

            public Object getValue(Object element, String property) {
                RefFilterHelper.RefFilter filter = (RefFilterHelper.RefFilter)element;
                return filter.getFilterString();
            }

            public boolean canModify(Object element, String property) {
                RefFilterHelper.RefFilter filter = (RefFilterHelper.RefFilter)element;
                return !filter.isPreconfigured();
            }
        });
    }

    private void setMessage(String text) {
        if (this.message.isDisposed()) {
            return;
        }
        if (text == null) {
            this.message.setImage(null);
            this.message.setText(UIText.GitHistoryPage_filterRefDialog_dialogMessage);
        } else {
            this.message.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            this.message.setText(text);
        }
    }

    private void createFilterCompositeButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        Button addNew = new Button(buttonComposite, 8);
        addNew.setText(UIText.GitHistoryPage_filterRefDialog_button_add);
        addNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitHistoryRefFilterConfigurationDialog.this.configsTable.applyEditorValue();
                RefFilterHelper refFilterHelper = GitHistoryRefFilterConfigurationDialog.this.helper;
                refFilterHelper.getClass();
                RefFilterHelper.RefFilter newFilter = new RefFilterHelper.RefFilter(refFilterHelper, GitHistoryRefFilterConfigurationDialog.NEW_FILTER_INITIAL_STRING);
                GitHistoryRefFilterConfigurationDialog.this.filters.add(newFilter);
                GitHistoryRefFilterConfigurationDialog.this.configsTable.refresh();
                GitHistoryRefFilterConfigurationDialog.this.configsTable.editElement((Object)newFilter, 0);
            }
        });
        this.setButtonLayoutData(addNew);
        Button addRefButton = new Button(buttonComposite, 8);
        addRefButton.setText(UIText.GitHistoryPage_filterRefDialog_button_addRef);
        addRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitHistoryRefFilterConfigurationDialog.this.configsTable.applyEditorValue();
                RefSelectionDialog dialog = new RefSelectionDialog(GitHistoryRefFilterConfigurationDialog.this.getShell(), GitHistoryRefFilterConfigurationDialog.this.repo);
                if (dialog.open() == 0) {
                    RefFilterHelper refFilterHelper = GitHistoryRefFilterConfigurationDialog.this.helper;
                    refFilterHelper.getClass();
                    RefFilterHelper.RefFilter newFilter = new RefFilterHelper.RefFilter(refFilterHelper, dialog.getRefName());
                    GitHistoryRefFilterConfigurationDialog.this.filters.add(newFilter);
                    GitHistoryRefFilterConfigurationDialog.this.configsTable.refresh();
                    GitHistoryRefFilterConfigurationDialog.this.configsTable.setSelection((ISelection)new StructuredSelection((Object)newFilter), true);
                }
            }
        });
        this.setButtonLayoutData(addRefButton);
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText(UIText.GitHistoryPage_filterRefDialog_button_remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitHistoryRefFilterConfigurationDialog.this.configsTable.applyEditorValue();
                GitHistoryRefFilterConfigurationDialog.this.removeSelectedFilters();
            }
        });
        this.removeButton.setEnabled(false);
        this.setButtonLayoutData(this.removeButton);
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText(UIText.GitHistoryPage_filterRefDialog_button_edit);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitHistoryRefFilterConfigurationDialog.this.configsTable.applyEditorValue();
                GitHistoryRefFilterConfigurationDialog.this.configsTable.editElement(GitHistoryRefFilterConfigurationDialog.this.configsTable.getStructuredSelection().getFirstElement(), 0);
            }
        });
        this.editButton.setEnabled(false);
        this.setButtonLayoutData(this.editButton);
    }

    private void createActionCompositeButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        Button setHeadOnly = new Button(buttonComposite, 8);
        setHeadOnly.setText(UIText.GitHistoryPage_filterRefDialog_button_headOnly);
        setHeadOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitHistoryRefFilterConfigurationDialog.this.configsTable.applyEditorValue();
                GitHistoryRefFilterConfigurationDialog.this.helper.selectOnlyHEAD(GitHistoryRefFilterConfigurationDialog.this.filters);
                GitHistoryRefFilterConfigurationDialog.this.configsTable.refresh();
            }
        });
        this.setButtonLayoutData(setHeadOnly);
        Button setCurrentBranchOnly = new Button(buttonComposite, 8);
        setCurrentBranchOnly.setText(UIText.GitHistoryPage_filterRefDialog_button_currentBranchOnly);
        setCurrentBranchOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitHistoryRefFilterConfigurationDialog.this.configsTable.applyEditorValue();
                GitHistoryRefFilterConfigurationDialog.this.helper.selectOnlyCurrentBranch(GitHistoryRefFilterConfigurationDialog.this.filters);
                GitHistoryRefFilterConfigurationDialog.this.configsTable.refresh();
            }
        });
        this.setButtonLayoutData(setCurrentBranchOnly);
        Button setAllBranchesAndTags = new Button(buttonComposite, 8);
        setAllBranchesAndTags.setText(UIText.GitHistoryPage_filterRefDialog_button_allBranchesAndTags);
        setAllBranchesAndTags.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitHistoryRefFilterConfigurationDialog.this.configsTable.applyEditorValue();
                GitHistoryRefFilterConfigurationDialog.this.helper.selectExactlyAllBranchesAndTags(GitHistoryRefFilterConfigurationDialog.this.filters);
                GitHistoryRefFilterConfigurationDialog.this.configsTable.refresh();
            }
        });
        this.setButtonLayoutData(setAllBranchesAndTags);
    }

    protected void okPressed() {
        this.configsTable.applyEditorValue();
        this.helper.setRefFilters(this.filters);
        if (this.defaultsPerformed) {
            this.helper.resetLastSelectionStateToDefault();
        }
        super.okPressed();
    }

    protected void performDefaults() {
        this.configsTable.applyEditorValue();
        this.filters = this.helper.getDefaults();
        this.configsTable.setInput(this.filters);
        this.defaultsPerformed = true;
        super.performDefaults();
    }

    private void init() {
        this.filters = this.helper.getRefFilters();
        this.predefinedPatterns = this.filters.stream().filter(RefFilterHelper.RefFilter::isPreconfigured).map(RefFilterHelper.RefFilter::getFilterString).collect(Collectors.toSet());
        if (this.helper.isOnlyHEADSelected(this.filters)) {
            this.helper.restoreLastSelectionState(this.filters);
        }
        this.configsTable.setInput(this.filters);
        this.configsTable.refresh();
    }

    private void removeSelectedFilters() {
        IStructuredSelection selection = this.configsTable.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.filters.removeAll(selection.toList());
        this.configsTable.refresh();
    }

    private void updateButtonEnablement() {
        IStructuredSelection selection = this.configsTable.getStructuredSelection();
        boolean allWriteable = false;
        if (!selection.isEmpty()) {
            List elements = selection.toList();
            allWriteable = elements.stream().allMatch(x -> x instanceof RefFilterHelper.RefFilter && !((RefFilterHelper.RefFilter)x).isPreconfigured());
        }
        this.removeButton.setEnabled(allWriteable);
        this.editButton.setEnabled(selection.size() == 1 && !((RefFilterHelper.RefFilter)selection.getFirstElement()).isPreconfigured());
    }

    private static class RefLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private RefLabelProvider() {
        }

        public String getText(Object element) {
            RefFilterHelper.RefFilter filter = (RefFilterHelper.RefFilter)element;
            Object result = filter.getFilterString();
            if (filter.isPreconfigured()) {
                result = (String)result + UIText.GitHistoryPage_filterRefDialog_preconfiguredText;
            }
            return result;
        }

        public Color getForeground(Object element) {
            RefFilterHelper.RefFilter filter = (RefFilterHelper.RefFilter)element;
            if (filter.isPreconfigured()) {
                return PlatformUI.getWorkbench().getDisplay().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private static class RefSelectionDialog
    extends AbstractBranchSelectionDialog {
        public RefSelectionDialog(Shell parentShell, Repository repository) {
            super(parentShell, repository, "", 254);
        }

        @Override
        protected void refNameSelected(String refName) {
            this.setOkButtonEnabled(refName != null);
        }

        @Override
        protected String getTitle() {
            return UIText.GitHistoryPage_filterRefDialog_selectRefDialog_dialogTitle;
        }

        @Override
        protected String getMessageText() {
            return UIText.GitHistoryPage_filterRefDialog_selectRefDialog_dialogMessage;
        }
    }
}

