/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.extensions.references.search.SearchEngine;
import org.eclipse.lemminx.extensions.references.search.SearchNode;
import org.eclipse.lemminx.extensions.references.search.SearchQuery;
import org.eclipse.lemminx.extensions.references.settings.XMLReferenceExpression;
import org.eclipse.lemminx.extensions.references.settings.XMLReferences;
import org.eclipse.lemminx.extensions.references.settings.XMLReferencesSettings;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class SearchQueryFactory {
    public static SearchNode.Direction getInversedDirection(DOMNode node, XMLReferenceExpression expression, SearchQuery.QueryDirection direction) {
        switch (direction) {
            case FROM_2_TO: {
                if (expression.matchTo(node)) {
                    return SearchNode.Direction.TO;
                }
                return null;
            }
            case TO_2_FROM: {
                if (expression.matchFrom(node)) {
                    return SearchNode.Direction.FROM;
                }
                return null;
            }
        }
        if (expression.matchFrom(node)) {
            return SearchNode.Direction.FROM;
        }
        if (expression.matchTo(node)) {
            return SearchNode.Direction.TO;
        }
        return null;
    }

    public static SearchNode.Direction getDirection(DOMNode node, XMLReferenceExpression expression, SearchQuery.QueryDirection queryDirection) {
        switch (queryDirection) {
            case TO_2_FROM: {
                if (expression.matchTo(node)) {
                    return SearchNode.Direction.TO;
                }
                return null;
            }
            case FROM_2_TO: {
                if (expression.matchFrom(node)) {
                    return SearchNode.Direction.FROM;
                }
                return null;
            }
        }
        if (expression.matchFrom(node)) {
            return SearchNode.Direction.FROM;
        }
        if (expression.matchTo(node)) {
            return SearchNode.Direction.TO;
        }
        return null;
    }

    public static SearchQuery createQuery(DOMNode node, int offset, XMLReferencesSettings settings) {
        DOMNode adjustedNode = SearchQueryFactory.findAttrOrTextNode(node, offset);
        if (adjustedNode == null) {
            return null;
        }
        SearchQuery query = SearchQueryFactory.internalCreateQuery(adjustedNode, offset, settings, SearchQuery.QueryDirection.FROM_2_TO);
        if (query != null) {
            return query;
        }
        return SearchQueryFactory.internalCreateQuery(adjustedNode, offset, settings, SearchQuery.QueryDirection.TO_2_FROM);
    }

    public static SearchQuery createFromQuery(DOMNode node, int offset, XMLReferencesSettings settings) {
        return SearchQueryFactory.createQuery(node, offset, settings, SearchQuery.QueryDirection.FROM_2_TO);
    }

    public static SearchQuery createToQuery(DOMNode node, int offset, XMLReferencesSettings settings) {
        return SearchQueryFactory.createQuery(node, offset, settings, SearchQuery.QueryDirection.TO_2_FROM);
    }

    public static SearchQuery createToQueryByRetrievingToBefore(DOMNode node, int offset, XMLReferencesSettings settings, CancelChecker cancelChecker) {
        SearchQuery query = SearchQueryFactory.createQuery(node, offset, settings, SearchQuery.QueryDirection.TO_2_FROM);
        if (query != null) {
            return query;
        }
        query = SearchQueryFactory.createQuery(node, offset, settings, SearchQuery.QueryDirection.FROM_2_TO);
        if (query != null) {
            AtomicReference to;
            block5: {
                query.setMatchNode(true);
                query.setSearchInIncludedFiles(true);
                to = new AtomicReference();
                try {
                    SearchEngine.getInstance().search(query, (fromSearchNode, toSearchNode, expression) -> {
                        to.set(toSearchNode);
                        throw new CancellationException();
                    }, cancelChecker);
                }
                catch (CancellationException e) {
                    if (cancelChecker == null) break block5;
                    cancelChecker.checkCanceled();
                }
            }
            SearchNode searchToNode = (SearchNode)to.get();
            if (searchToNode != null) {
                SearchQuery.QueryDirection queryDirection = SearchQuery.QueryDirection.TO_2_FROM;
                List<XMLReferenceExpression> expressions = SearchQueryFactory.findExpressions(searchToNode.getNode(), settings, queryDirection);
                return new SearchQuery(searchToNode, expressions, queryDirection);
            }
        }
        return null;
    }

    public static SearchQuery createQuery(DOMNode node, XMLReferencesSettings settings, SearchQuery.QueryDirection direction) {
        return SearchQueryFactory.createQuery(node, -1, settings, direction);
    }

    public static SearchQuery createQuery(DOMNode node, int offset, XMLReferencesSettings settings, SearchQuery.QueryDirection direction) {
        DOMNode adjustedNode = SearchQueryFactory.findAttrOrTextNode(node, offset);
        if (adjustedNode == null) {
            return null;
        }
        return SearchQueryFactory.internalCreateQuery(adjustedNode, offset, settings, direction);
    }

    private static SearchQuery internalCreateQuery(DOMNode adjustedNode, int offset, XMLReferencesSettings settings, SearchQuery.QueryDirection direction) {
        List<XMLReferenceExpression> expressions = SearchQueryFactory.findExpressions(adjustedNode, settings, direction);
        if (expressions == null) {
            return null;
        }
        return new SearchQuery(adjustedNode, offset, expressions, direction);
    }

    private static DOMNode findAttrOrTextNode(DOMNode node, int offset) {
        if (node == null || node.isText() || node.isAttribute() || node.isOwnerDocument()) {
            return node;
        }
        if (node.isElement()) {
            DOMText text = ((DOMElement)node).findTextAt(offset);
            if (text != null) {
                return text;
            }
            DOMAttr attr = node.findAttrAt(offset);
            if (attr != null) {
                return attr;
            }
        }
        return null;
    }

    private static List<XMLReferenceExpression> findExpressions(DOMNode node, XMLReferencesSettings xmlReferencesSettings, SearchQuery.QueryDirection queryDirection) {
        List<XMLReferences> allReferences;
        List<XMLReferences> list = allReferences = xmlReferencesSettings != null ? xmlReferencesSettings.getReferences() : null;
        if (allReferences == null) {
            return null;
        }
        DOMDocument document = node.getOwnerDocument();
        String uri = document.getDocumentURI();
        ArrayList<XMLReferenceExpression> matchedExpressions = null;
        for (XMLReferences references : allReferences) {
            List<XMLReferenceExpression> expressions;
            if (!references.matches(uri) || (expressions = references.getExpressions()) == null) continue;
            if (node.isOwnerDocument()) {
                if (matchedExpressions == null) {
                    matchedExpressions = new ArrayList<XMLReferenceExpression>();
                }
                matchedExpressions.addAll(expressions);
                continue;
            }
            for (XMLReferenceExpression expression : expressions) {
                SearchNode.Direction direction = SearchQueryFactory.getDirection(node, expression, queryDirection);
                if (direction == null) continue;
                if (matchedExpressions == null) {
                    matchedExpressions = new ArrayList();
                }
                matchedExpressions.add(expression);
            }
        }
        return matchedExpressions;
    }
}

