/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.views.AbstractProfilerView;
import org.eclipse.php.profile.ui.views.ProfilingMonitorElement;
import org.eclipse.php.profile.ui.views.ProfilingMonitorSorter;
import org.eclipse.php.profile.ui.views.ProfilingMonitorViewElement;
import org.eclipse.php.profile.ui.wizards.ExportSessionWizard;
import org.eclipse.php.profile.ui.wizards.HTMLReportWizard;
import org.eclipse.php.profile.ui.wizards.ImportSessionWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;

public class ProfilingMonitorActionGroup
extends ActionGroup {
    private TreeViewer fTreeViewer;
    private DeleteAction fDeleteAction;
    private ImportAction fImportAction;
    private ExportAction fExportAction;
    private OpenViewAction fOpenViewAction;
    private ReportViewAction fReportViewAction;
    private SortAction fSortAction;

    public ProfilingMonitorActionGroup(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
        this.fDeleteAction = new DeleteAction();
        this.fImportAction = new ImportAction();
        this.fExportAction = new ExportAction();
        this.fOpenViewAction = new OpenViewAction();
        this.fReportViewAction = new ReportViewAction();
        this.fSortAction = new SortAction();
        this.updateSelectionDependentActions(this.fTreeViewer.getSelection());
    }

    public void updateSelectionDependentActions(ISelection selection) {
        this.fDeleteAction.update(selection);
        this.fExportAction.update(selection);
        this.fOpenViewAction.update(selection);
        this.fReportViewAction.update(selection);
    }

    private void doOpenView(ProfilingMonitorViewElement viewElement) {
        IWorkbenchPage page = ProfilerUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IViewPart view = page.showView(viewElement.getViewId());
            if (view instanceof AbstractProfilerView) {
                ((AbstractProfilerView)view).setInput(viewElement.getParent().getProfilerDB());
            }
        }
        catch (PartInitException e) {
            ProfilerUiPlugin.log(e);
        }
    }

    public void handlerDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object element = sSelection.getFirstElement();
            if (element instanceof ProfilingMonitorElement) {
                boolean expanded = !this.fTreeViewer.getExpandedState(element);
                this.fTreeViewer.setExpandedState(element, expanded);
                this.fTreeViewer.getControl().setRedraw(true);
            } else if (element instanceof ProfilingMonitorViewElement) {
                this.doOpenView((ProfilingMonitorViewElement)element);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IAction)this.fDeleteAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.fSortAction);
        toolbarManager.add((IContributionItem)new Separator());
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.fTreeViewer.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element == null) {
                menu.add((IAction)this.fImportAction);
            } else if (element instanceof ProfilingMonitorElement) {
                menu.add((IAction)this.fDeleteAction);
                menu.add((IContributionItem)new Separator());
                menu.add((IAction)this.fImportAction);
                menu.add((IAction)this.fExportAction);
                menu.add((IContributionItem)new Separator());
                menu.add((IAction)this.fReportViewAction);
            } else if (element instanceof ProfilingMonitorViewElement) {
                menu.add((IAction)this.fOpenViewAction);
                menu.add((IContributionItem)new Separator());
                menu.add((IAction)this.fReportViewAction);
            }
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    private Object[] getSelectedElements(ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            return sSelection.toArray();
        }
        return null;
    }

    private boolean profileSessionsSelected(ISelection selection) {
        Object[] elements = this.getSelectedElements(selection);
        boolean selected = elements.length > 0;
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof ProfilingMonitorElement)) {
                selected = false;
            }
            ++i;
        }
        return selected;
    }

    class DeleteAction
    extends Action {
        public DeleteAction() {
            super(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.0"));
            this.setDescription(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.1"));
            this.setToolTipText(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.2"));
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public void run() {
            if (MessageDialog.openConfirm((Shell)ProfilingMonitorActionGroup.this.fTreeViewer.getTree().getShell(), (String)PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.25"), (String)PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.20"))) {
                Object[] elements = ProfilingMonitorActionGroup.this.getSelectedElements(ProfilingMonitorActionGroup.this.fTreeViewer.getSelection());
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof ProfilingMonitorElement) {
                        ProfileSessionsManager.removeSession((ProfilerDB)((ProfilingMonitorElement)elements[i]).getProfilerDB());
                    }
                    ++i;
                }
            }
        }

        public void update(ISelection selection) {
            this.setEnabled(ProfilingMonitorActionGroup.this.profileSessionsSelected(selection));
        }
    }

    class ExportAction
    extends Action {
        public ExportAction() {
            super(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.5"));
            this.setDescription(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.6"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ETOOL_EXPORT_WIZ"));
        }

        public void run() {
            ExportSessionWizard wizard = new ExportSessionWizard();
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }

        public void update(ISelection selection) {
            this.setEnabled(ProfilingMonitorActionGroup.this.profileSessionsSelected(selection));
        }
    }

    class ImportAction
    extends Action {
        public ImportAction() {
            super(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.3"));
            this.setDescription(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.4"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ETOOL_IMPORT_WIZ"));
        }

        public void run() {
            ImportSessionWizard wizard = new ImportSessionWizard();
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    class OpenViewAction
    extends Action {
        public OpenViewAction() {
            super(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.7"));
            this.setDescription(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.8"));
        }

        public void run() {
            Object element;
            ISelection selection = ProfilingMonitorActionGroup.this.fTreeViewer.getSelection();
            if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ProfilingMonitorViewElement) {
                ProfilingMonitorActionGroup.this.doOpenView((ProfilingMonitorViewElement)element);
            }
        }

        public void update(ISelection selection) {
            Object element;
            boolean enabled = false;
            if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ProfilingMonitorViewElement) {
                enabled = true;
            }
            this.setEnabled(enabled);
        }
    }

    class ReportViewAction
    extends Action {
        public ReportViewAction() {
            super(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.13"));
            this.setDescription(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.14"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_OBJ_REPORT"));
        }

        public void run() {
            HTMLReportWizard wizard = new HTMLReportWizard();
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }

        public void update(ISelection selection) {
            Object element;
            IStructuredSelection sSelection;
            boolean enabled = false;
            if (selection != null && selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1 && ((element = sSelection.getFirstElement()) instanceof ProfilingMonitorViewElement || element instanceof ProfilingMonitorElement)) {
                enabled = true;
            }
            this.setEnabled(enabled);
        }
    }

    class SortAction
    extends Action
    implements IMenuCreator {
        private IPreferenceStore fStore;
        private Menu fMenu;

        public SortAction() {
            super(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.15"), 4);
            this.setDescription(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.16"));
            this.setToolTipText(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.17"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_SORT"));
            this.setMenuCreator(this);
            this.fStore = ProfilerUiPlugin.getDefault().getPreferenceStore();
            ProfilingMonitorActionGroup.this.fTreeViewer.setSorter((ViewerSorter)new ProfilingMonitorSorter(this.fStore.getInt("profilingMonitorSortOrder")));
        }

        public void run() {
            ((ProfilingMonitorSorter)ProfilingMonitorActionGroup.this.fTreeViewer.getSorter()).setMode(this.fStore.getInt("profilingMonitorSortOrder"));
            BusyIndicator.showWhile((Display)ProfilingMonitorActionGroup.this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ((SortAction)SortAction.this).ProfilingMonitorActionGroup.this.fTreeViewer.refresh();
                }
            });
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            ActionContributionItem item = new ActionContributionItem((IAction)new SortByAction(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.18"), 0));
            item.fill(this.fMenu, -1);
            item = new ActionContributionItem((IAction)new SortByAction(PHPProfileUIMessages.getString("ProfilingMonitorActionGroup.19"), 1));
            item.fill(this.fMenu, -1);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        class SortByAction
        extends Action {
            private int fMode;

            public SortByAction(String label, int mode) {
                super(label);
                this.setDescription(label);
                this.setToolTipText(label);
                this.fMode = mode;
                this.setChecked(SortAction.this.fStore.getInt("profilingMonitorSortOrder") == this.fMode);
            }

            public void run() {
                SortAction.this.fStore.setValue("profilingMonitorSortOrder", this.fMode);
                SortAction.this.run();
            }
        }
    }
}

