/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.saveparticipant;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.ui.editor.saveparticipant.IPostSaveListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.OrganizeUseStatementsAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class OrganizeUseStatmentsSaveParticipant
implements IPostSaveListener {
    public static final String ID = "OrganizeUseStatements";
    public static final String EDITOR_SAVE_PARTICIPANT_PREFIX = "editor_save_participant_";
    private boolean organizeOnSaveEnabled = false;

    public String getName() {
        return "Organize use statements";
    }

    public String getId() {
        return ID;
    }

    public void updateSaveActionsState(@Nullable IProject project) {
        PreferencesSupport prefSupport = new PreferencesSupport("org.eclipse.php.ui");
        String formatOnSavePref = prefSupport.getPreferencesValue("cleanup.organize.on.save", null, project);
        this.organizeOnSaveEnabled = Boolean.parseBoolean(formatOnSavePref);
    }

    public boolean isEnabled(ISourceModule compilationUnit) {
        return new PreferencesLookupDelegate(compilationUnit.getScriptProject().getProject()).getBoolean("org.eclipse.php.ui", "editor_save_participant_OrganizeUseStatements");
    }

    public boolean needsChangedRegions(ISourceModule compilationUnit) throws CoreException {
        return false;
    }

    public void saved(ISourceModule compilationUnit, IRegion[] changedRegions, IProgressMonitor monitor) throws CoreException {
        IScriptProject project = compilationUnit.getScriptProject();
        this.updateSaveActionsState(project != null ? project.getProject() : null);
        if (!this.organizeOnSaveEnabled) {
            return;
        }
        FileEditorInput input = new FileEditorInput((IFile)compilationUnit.getResource());
        IWorkbenchPage p = PHPUiPlugin.getActivePage();
        if (p == null) {
            return;
        }
        IEditorPart part = p.findEditor((IEditorInput)input);
        if (part instanceof PHPStructuredEditor) {
            try {
                ASTParser parser = ASTParser.newParser((ISourceModule)compilationUnit);
                Program astRoot = parser.createAST(monitor);
                OrganizeUseStatementsAction action = new OrganizeUseStatementsAction(part);
                action.run(compilationUnit, astRoot);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", e.toString(), (Throwable)e));
            }
        }
    }
}

