/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.importer;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class PHPProjectConfigurator
implements ProjectConfigurator {
    private static final String COMPOSER_JSON = "composer.json";
    private static final String VENDOR_DIRECTORY = "vendor";
    private static final Set<String> SEARCHED_FILES = new HashSet<String>(Arrays.asList("index.php", "composer.json"));

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        LinkedList<File> directoriesToProcess = new LinkedList<File>();
        directoriesToProcess.addFirst(root);
        while (!directoriesToProcess.isEmpty()) {
            if (monitor.isCanceled()) {
                return Collections.emptySet();
            }
            File current = (File)directoriesToProcess.pop();
            if (!current.isDirectory()) continue;
            File[] fileArray = current.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    directoriesToProcess.add(file);
                } else if (file.isFile() && SEARCHED_FILES.contains(file.getName())) {
                    return Collections.singleton(current);
                }
                ++n2;
            }
        }
        return Collections.emptySet();
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        return this.shouldBeAnEclipseProject((IContainer)project, monitor);
    }

    public void configure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        try {
            if (PHPToolkitUtil.isPHPProject((IProject)project)) {
                return;
            }
            String[] natureIds = new String[]{"org.eclipse.php.core.PHPNature"};
            if (natureIds != null) {
                IProjectDescription desc = project.getDescription();
                desc.setNatureIds(natureIds);
                project.setDescription(desc, null);
            }
            if (project.getFile(COMPOSER_JSON).exists()) {
                IFolder vendorFolder = project.getFolder(VENDOR_DIRECTORY);
                LibraryFolderManager.getInstance().useAsLibraryFolder(new IFolder[]{vendorFolder}, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            }
        }
        catch (InterruptedException | CoreException | OperationCanceledException e) {
            Logger.logException((Throwable)e);
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        boolean shouldBeProject = false;
        for (String filename : SEARCHED_FILES) {
            IFile file = container.getFile((IPath)new Path(filename));
            if (!file.exists()) continue;
            shouldBeProject = true;
            break;
        }
        return shouldBeProject;
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return null;
    }
}

