/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.viewers;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.ChartPanelSelectionHandler;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.ChartPanelViewer;
import org.eclipse.trace4cps.common.jfreechart.ui.widgets.ChartPanelComposite;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.util.Args;

public abstract class ChartPanelStructuredViewer
extends StructuredViewer
implements ChartPanelViewer {
    private final Composite parentComposite;
    private List widgetSelection = Collections.EMPTY_LIST;
    private ChartPanelControlTuple controlTuple = null;

    public ChartPanelStructuredViewer(Composite parent) {
        this.parentComposite = parent;
    }

    @Override
    public Control getControl() {
        return this.getControlTuple().getControl();
    }

    @Override
    public ChartPanelComposite getChartPanelComposite() {
        return this.getControlTuple().getChartPanelComposite();
    }

    @Override
    public ChartPanelSelectionHandler getChartPanelSelectionHandler() {
        return this.getControlTuple().getChartPanelSelectionHandler();
    }

    private ChartPanelControlTuple getControlTuple() {
        if (this.controlTuple == null) {
            this.controlTuple = this.createControl(this.parentComposite, 768, ChartPanelSelectionHandler.SelectionType.Multi);
            this.configureChartPanel();
        }
        return this.controlTuple;
    }

    protected ChartPanelControlTuple createControl(Composite parent, int style, ChartPanelSelectionHandler.SelectionType selectionType) {
        ChartPanelComposite composite = new ChartPanelComposite(parent, style);
        ChartPanelSelectionHandler selectionHandler = new ChartPanelSelectionHandler(composite.getChartPanel(), (ISelectionProvider)this, selectionType);
        return new ChartPanelControlTuple((Control)composite, composite, selectionHandler);
    }

    protected void configureChartPanel() {
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.refresh();
    }

    public final void refresh(boolean updateLabels) {
        this.refresh();
    }

    public final void refresh(Object element, boolean updateLabels) {
        this.refresh(element);
    }

    @Override
    public final void refresh() {
        this.refresh(this.getRoot());
    }

    protected final void internalRefresh(Object element, boolean updateLabels) {
        super.internalRefresh(element, updateLabels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void internalRefresh(Object element) {
        JFreeChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        this.getChartPanelComposite().setNotify(false);
        try {
            JFreeChart jFreeChart = chart;
            synchronized (jFreeChart) {
                this.refreshChart(element);
            }
        }
        finally {
            this.getChartPanelComposite().setNotify(true);
        }
    }

    protected abstract void refreshChart(Object var1);

    protected List getSelectionFromWidget() {
        return this.widgetSelection;
    }

    protected void setSelectionToWidget(List selection, boolean reveal) {
        this.widgetSelection = selection;
    }

    protected Widget doFindInputItem(Object element) {
        return this.getChartPanelComposite();
    }

    protected Widget doFindItem(Object element) {
        return this.doFindInputItem(element);
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        Plot plot;
        if (item instanceof ChartPanelComposite && (plot = ((ChartPanelComposite)item).getPlot()) != null) {
            plot.notifyListeners(new PlotChangeEvent(plot));
        }
    }

    public void reveal(Object element) {
    }

    protected final class ChartPanelControlTuple {
        private final Control control;
        private final ChartPanelComposite chartPanelComposite;
        private final ChartPanelSelectionHandler chartPanelSelectionHandler;

        public ChartPanelControlTuple(Control control, ChartPanelComposite chartPanelComposite, ChartPanelSelectionHandler chartPanelSelectionHandler) {
            Args.nullNotPermitted((Object)control, (String)"control");
            Args.nullNotPermitted((Object)((Object)chartPanelComposite), (String)"chartPanelComposite");
            Args.nullNotPermitted((Object)chartPanelSelectionHandler, (String)"chartPanelSelectionHandler");
            this.control = control;
            this.chartPanelComposite = chartPanelComposite;
            this.chartPanelSelectionHandler = chartPanelSelectionHandler;
        }

        public Control getControl() {
            return this.control;
        }

        public ChartPanelComposite getChartPanelComposite() {
            return this.chartPanelComposite;
        }

        public ChartPanelSelectionHandler getChartPanelSelectionHandler() {
            return this.chartPanelSelectionHandler;
        }

        public ChartPanelControlTuple wrapControl(Control control) {
            return new ChartPanelControlTuple(control, this.chartPanelComposite, this.chartPanelSelectionHandler);
        }
    }
}

