/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler.Messages;

@NonNullByDefault(value={})
class ParameterDialog
extends Dialog {
    private static final Color GRAY_COLOR = Display.getCurrent().getSystemColor(16);
    private String fTitle;
    private String fMessage;
    private String fValue = "";
    private IInputValidator fValidator;
    private Button fOkButton;
    private Text fText;
    private Text fErrorMessageText;
    private String fErrorMessage;
    private Text fBaseCommandText;
    private final String fBaseCommand;

    public ParameterDialog(Shell parentShell, String dialogTitle, String dialogMessage, String baseCommand, IInputValidator validator) {
        super(parentShell);
        this.fTitle = dialogTitle;
        this.fMessage = dialogMessage;
        this.fValue = "";
        this.fValidator = validator;
        this.fBaseCommand = baseCommand;
    }

    protected void buttonPressed(int buttonId) {
        this.fValue = buttonId == 0 ? this.fText.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fText.setFocus();
        if (this.fValue != null) {
            this.fText.setText(this.fValue);
            this.fText.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(Messages.ParameterDialog_BaseCommand + ":");
        this.fBaseCommandText = new Text(composite, this.getInputTextStyle() | 8);
        this.fBaseCommandText.setLayoutData((Object)new GridData(768));
        this.fBaseCommandText.setText(this.fBaseCommand);
        this.fBaseCommandText.setForeground(GRAY_COLOR);
        if (this.fMessage != null) {
            label = new Label(composite, 64);
            label.setText(this.fMessage);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.fText = new Text(composite, this.getInputTextStyle());
        this.fText.setLayoutData((Object)new GridData(768));
        this.fText.addModifyListener(e -> this.validateInput());
        this.fErrorMessageText = new Text(composite, 72);
        this.fErrorMessageText.setLayoutData((Object)new GridData(768));
        this.fErrorMessageText.setBackground(this.fErrorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.fErrorMessage);
        ParameterDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Button getOkButton() {
        return this.fOkButton;
    }

    public String getValue() {
        return this.fValue;
    }

    protected void validateInput() {
        String errMsg = null;
        if (this.fValidator != null) {
            errMsg = this.fValidator.isValid(this.fText.getText());
        }
        this.setErrorMessage(errMsg);
    }

    private void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
        if (this.fErrorMessageText != null && !this.fErrorMessageText.isDisposed()) {
            this.fErrorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.fErrorMessageText.setEnabled(hasError);
            this.fErrorMessageText.setVisible(hasError);
            this.fErrorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

