/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.consumer;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.chart.core.aggregator.IConsumerAggregator;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.IChartConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.XYSeriesConsumer;

public class XYChartConsumer
implements IChartConsumer {
    private final List<XYSeriesConsumer> fSeries;
    private final @Nullable IConsumerAggregator fXAggregator;
    private final @Nullable IConsumerAggregator fYAggregator;

    public XYChartConsumer(List<XYSeriesConsumer> series, @Nullable IConsumerAggregator xAggregator, @Nullable IConsumerAggregator yAggregator) {
        this.fSeries = ImmutableList.copyOf(series);
        this.fXAggregator = xAggregator;
        this.fYAggregator = yAggregator;
    }

    public void accept(Object obj) {
        this.fSeries.forEach(consumer -> consumer.accept(obj));
    }

    public void finish() {
        IConsumerAggregator aggregatorY;
        IConsumerAggregator aggregatorX = this.fXAggregator;
        if (aggregatorX != null) {
            this.fSeries.forEach(s -> aggregatorX.accept((Object)s.getXConsumer()));
        }
        if ((aggregatorY = this.fYAggregator) != null) {
            this.fSeries.forEach(s -> aggregatorY.accept((Object)s.getYConsumer()));
        }
    }

    public Collection<XYSeriesConsumer> getSeries() {
        return this.fSeries;
    }

    public @Nullable IConsumerAggregator getXAggregator() {
        return this.fXAggregator;
    }

    public @Nullable IConsumerAggregator getYAggregator() {
        return this.fYAggregator;
    }
}

