/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.virgo.ide.bundlerepository.domain.OsgiVersion;
import org.eclipse.virgo.ide.bundlerepository.domain.PackageExport;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactRepository;
import org.eclipse.virgo.ide.runtime.core.artefacts.BundleArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefactTyped;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.virgo.ide.ui.editors.AbstractImportSection;
import org.eclipse.virgo.ide.ui.editors.BundleDependencyPropertiesDialog;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;
import org.osgi.framework.Version;

public class BundleImportPackageSection
extends AbstractImportSection {
    private static final String DESCRIPTION = "Specify packages on which this bundle depends without explicitly identifying their originating bundle.";
    private Action fGoToAction;
    private static final int ADD_INDEX = 0;
    private static final int ADD_REMOTE_BUNDLE_INDEX = 1;
    private static final int REMOVE_INDEX = 2;
    private static final int PROPERTIES_INDEX = 3;

    public BundleImportPackageSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.ImportPackageSection_add, "Download...", PDEUIMessages.ImportPackageSection_remove, PDEUIMessages.ImportPackageSection_properties});
        this.getSection().setText("Import Package");
        this.getSection().setDescription(DESCRIPTION);
        this.getTablePart().setEditable(false);
    }

    protected void setElementsLocal(AbstractImportSection.ImportListSelectionDialog dialog) {
        IProject project = ((BundleManifestEditor)this.getPage().getEditor()).getCommonProject();
        Set packages = RepositoryUtils.getImportPackageProposals((IProject)project, (String)"");
        ImportPackageHeader header = (ImportPackageHeader)this.getBundle().getManifestHeader("Import-Package");
        HashSet<PackageExport> filteredElements = new HashSet<PackageExport>();
        if (header != null) {
            ImportPackageObject[] filter = header.getPackages();
            for (PackageExport proposal : packages) {
                ImportPackageObject[] importPackageObjectArray = filter;
                int n = filter.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportPackageObject imported = importPackageObjectArray[n2];
                    if (proposal.getName().equalsIgnoreCase(imported.getName())) {
                        filteredElements.add(proposal);
                    }
                    ++n2;
                }
            }
            packages.removeAll(filteredElements);
        }
        dialog.setElements(packages.toArray());
    }

    protected void setElementsRemote(AbstractImportSection.ImportListSelectionDialog dialog) {
        Iterable bundles = null;
        ArtefactRepository bundleRepository = RepositoryUtils.searchForArtifacts((String)"", (boolean)true, (boolean)false);
        bundles = bundleRepository.getBundles();
        HashSet allPackageExports = new HashSet();
        for (IArtefactTyped currBundleArtefact : bundles) {
            allPackageExports.addAll(((BundleArtefact)currBundleArtefact).getExports());
        }
        dialog.setElements(allPackageExports.toArray());
    }

    protected ITableLabelProvider getLabelProvider() {
        return new ImportPackageLabelProvider();
    }

    protected void fillContextMenu(IMenuManager manager) {
        boolean singleSelection;
        ISelection selection = this.fViewer.getSelection();
        boolean bl = singleSelection = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1;
        if (singleSelection) {
            manager.add((IAction)this.fGoToAction);
        }
        super.fillContextMenu(manager);
    }

    protected void handleAdd() {
        this.internalHandleAdd(false);
    }

    private void internalHandleAdd(final boolean addRemote) {
        final AbstractImportSection.ImportListSelectionDialog dialog = new AbstractImportSection.ImportListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new BundleImportPackageDialogLabelProvider());
        Runnable runnable = new Runnable(){

            public void run() {
                if (addRemote) {
                    BundleImportPackageSection.this.setElementsRemote(dialog);
                } else {
                    BundleImportPackageSection.this.setElementsLocal(dialog);
                }
                dialog.setMultipleSelection(true);
                dialog.setMessage(PDEUIMessages.ImportPackageSection_required);
                dialog.setTitle(PDEUIMessages.ImportPackageSection_selection);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, (int)400, (int)500);
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            if (addRemote) {
                this.downloadBundlesForSelectedPackages(selected);
            }
            this.addSelectedPackagesToManifest(selected);
        }
    }

    private void downloadBundlesForSelectedPackages(Object[] selected) {
        HashSet<BundleArtefact> bundleArtefacts = new HashSet<BundleArtefact>();
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            PackageExport currPackageExport = (PackageExport)element;
            bundleArtefacts.add(currPackageExport.getBundle());
            ++n2;
        }
        IProject project = ((BundleManifestEditor)this.getPage().getEditor()).getCommonProject();
        RepositoryUtils.downloadArifacts(bundleArtefacts, (IProject)project, (Shell)Display.getDefault().getActiveShell(), (boolean)true);
    }

    private void addSelectedPackagesToManifest(Object[] selected) {
        ImportPackageHeader importPackageHeader = (ImportPackageHeader)this.getBundle().getManifestHeader("Import-Package");
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            PackageExport currPackage = (PackageExport)element;
            if (importPackageHeader == null) {
                this.getBundle().setHeader("Import-Package", "");
                importPackageHeader = (ImportPackageHeader)this.getBundle().getManifestHeader("Import-Package");
            }
            String versionString = null;
            OsgiVersion osgiVers = currPackage.getVersion();
            if (osgiVers.getMajor() != 0 || osgiVers.getMinor() != 0 || osgiVers.getService() != 0 || osgiVers.getQualifier() != null && !osgiVers.getQualifier().trim().equals("")) {
                versionString = "[" + currPackage.getVersion().toString() + "," + currPackage.getVersion().toString() + "]";
            }
            ImportPackageObject newPackageObject = new ImportPackageObject((ManifestHeader)importPackageHeader, currPackage.getName(), versionString, "version");
            importPackageHeader.addPackage((PackageObject)newPackageObject);
            ++n2;
        }
    }

    protected void handleRemove() {
        Object[] removed = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        ImportPackageHeader importPackageHeader = (ImportPackageHeader)this.getBundle().getManifestHeader("Import-Package");
        Object[] objectArray = removed;
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            importPackageHeader.removePackage((PackageObject)element);
            ++n2;
        }
    }

    protected void handleOpenProperties() {
        Object[] selected = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        ImportPackageObject first = (ImportPackageObject)selected[0];
        BundleDependencyPropertiesDialog dialog = new BundleDependencyPropertiesDialog(this.isEditable(), false, false, first.isOptional(), first.getVersion(), true, true);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, (int)400, (int)-1);
        if (selected.length == 1) {
            dialog.setTitle(((ImportPackageObject)selected[0]).getName());
        } else {
            dialog.setTitle(PDEUIMessages.ExportPackageSection_props);
        }
        if (dialog.open() == 0 && this.isEditable()) {
            String newVersion = dialog.getVersion();
            boolean newOptional = dialog.isOptional();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                ImportPackageObject object = (ImportPackageObject)element;
                if (!newVersion.equals(object.getVersion())) {
                    object.setVersion(newVersion);
                }
                if (!newOptional == object.isOptional()) {
                    object.setOptional(newOptional);
                }
                ++n2;
            }
        }
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleGoToPackage((ISelection)selection);
    }

    protected void makeActions() {
        super.makeActions();
        this.fGoToAction = new Action(PDEUIMessages.ImportPackageSection_goToPackage){

            public void run() {
                BundleImportPackageSection.this.handleGoToPackage(BundleImportPackageSection.this.fViewer.getSelection());
            }
        };
    }

    private IPackageFragment getPackageFragment(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            if (selection.size() != 1) {
                return null;
            }
            IBaseModel model = this.getPage().getModel();
            if (!(model instanceof IPluginModelBase)) {
                return null;
            }
            return PDEJavaHelper.getPackageFragment((String)((PackageObject)selection.getFirstElement()).getName(), (String)((IPluginModelBase)model).getPluginBase().getId(), (IProject)this.getPage().getPDEEditor().getCommonProject());
        }
        return null;
    }

    private void handleGoToPackage(ISelection selection) {
        IPackageFragment frag = this.getPackageFragment(selection);
        if (frag != null) {
            try {
                IViewPart part = PDEPlugin.getActivePage().showView("org.eclipse.jdt.ui.PackageExplorer");
                ShowInPackageViewAction action = new ShowInPackageViewAction((IWorkbenchSite)part.getSite());
                action.run((IJavaElement)frag);
            }
            catch (PartInitException partInitException) {}
        }
    }

    protected int getAddIndex() {
        return 0;
    }

    protected int getRemoveIndex() {
        return 2;
    }

    protected int getPropertiesIndex() {
        return 3;
    }

    protected IContentProvider getContentProvider() {
        return new ImportPackageContentProvider();
    }

    protected String getHeaderConstant() {
        return "Import-Package";
    }

    protected void buttonSelected(int index) {
        if (index == 1) {
            this.internalHandleAdd(true);
        } else {
            super.buttonSelected(index);
        }
    }

    class BundleImportPackageDialogLabelProvider
    extends LabelProvider {
        BundleImportPackageDialogLabelProvider() {
        }

        public Image getImage(Object element) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }

        public String getText(Object element) {
            PackageExport packageExport = (PackageExport)element;
            String label = packageExport.getName();
            if (packageExport.getVersion() != null) {
                label = String.valueOf(label) + " " + packageExport.getVersion();
            }
            return label;
        }
    }

    class ImportItemWrapper {
        Object fUnderlying;

        public ImportItemWrapper(Object underlying) {
            this.fUnderlying = underlying;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImportItemWrapper) {
                ImportItemWrapper item = (ImportItemWrapper)obj;
                return this.getName().equals(item.getName());
            }
            return false;
        }

        public String getName() {
            if (this.fUnderlying instanceof ExportPackageDescription) {
                return ((ExportPackageDescription)this.fUnderlying).getName();
            }
            if (this.fUnderlying instanceof IPackageFragment) {
                return ((IPackageFragment)this.fUnderlying).getElementName();
            }
            if (this.fUnderlying instanceof ExportPackageObject) {
                return ((ExportPackageObject)this.fUnderlying).getName();
            }
            return null;
        }

        public Version getVersion() {
            String version;
            if (this.fUnderlying instanceof ExportPackageDescription) {
                return ((ExportPackageDescription)this.fUnderlying).getVersion();
            }
            if (this.fUnderlying instanceof ExportPackageObject && (version = ((ExportPackageObject)this.fUnderlying).getVersion()) != null) {
                return new Version(version);
            }
            return null;
        }

        boolean hasVersion() {
            return this.hasEPD() && ((ExportPackageDescription)this.fUnderlying).getVersion() != null;
        }

        boolean hasEPD() {
            return this.fUnderlying instanceof ExportPackageDescription;
        }
    }

    class ImportPackageContentProvider
    extends DefaultTableProvider {
        ImportPackageContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ImportPackageHeader header = (ImportPackageHeader)BundleImportPackageSection.this.getBundle().getManifestHeader("Import-Package");
            if (header == null) {
                return new Object[0];
            }
            return header.getPackages();
        }
    }

    class ImportPackageLabelProvider
    extends AbstractImportSection.AbstractSectionViewerLabelProvider {
        ImportPackageLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }

        public String getColumnText(Object element, int columnIndex) {
            ImportPackageObject importPackageObject = (ImportPackageObject)element;
            String label = importPackageObject.getName();
            if (importPackageObject.getVersion() != null) {
                label = String.valueOf(label) + " " + importPackageObject.getVersion();
            }
            return label;
        }
    }
}

