/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.core.classpath;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.jdt.internal.core.util.ClasspathUtils;
import org.eclipse.virgo.ide.manifest.core.IBundleManifestChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerClasspathContainerUpdateJob
extends WorkspaceJob {
    private static final Queue<IJavaProject> SCHEDULED_PROJECTS = new ConcurrentLinkedQueue<IJavaProject>();
    private static LimitConcurrentClasspathUpdatesListener limitConcurrentClasspathUpdatesListener = new LimitConcurrentClasspathUpdatesListener();
    private final IJavaProject javaProject;
    private Set<IBundleManifestChangeListener.Type> types;

    private ServerClasspathContainerUpdateJob(IJavaProject javaProject, Set<IBundleManifestChangeListener.Type> types) {
        super("Updating bundle classpath container for project '" + javaProject.getElementName() + "'");
        this.javaProject = javaProject;
        this.types = types;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.javaProject.getProject().isOpen() || monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            ClasspathUtils.updateClasspathContainer(this.javaProject, this.types, monitor);
        }
        catch (Exception exception) {
            return Status.CANCEL_STATUS;
        }
        return new Status(0, "org.eclipse.virgo.ide.jdt.core", "Updated SpringSource dm Server classpath container");
    }

    public static void scheduleClasspathContainerUpdateJob(IJavaProject javaProject, Set<IBundleManifestChangeListener.Type> types) {
        if (javaProject != null && !SCHEDULED_PROJECTS.contains(javaProject) && types.size() > 0 && ClasspathUtils.hasClasspathContainer(javaProject)) {
            ServerClasspathContainerUpdateJob.newClasspathContainerUpdateJob(javaProject, types);
        }
    }

    private static ServerClasspathContainerUpdateJob newClasspathContainerUpdateJob(IJavaProject javaProject, Set<IBundleManifestChangeListener.Type> types) {
        ServerClasspathContainerUpdateJob job = new ServerClasspathContainerUpdateJob(javaProject, types);
        job.setPriority(40);
        job.setSystem(true);
        job.addJobChangeListener(new DuplicateJobListener());
        job.addJobChangeListener(limitConcurrentClasspathUpdatesListener);
        job.sleep();
        ServerClasspathContainerUpdateJob.limitConcurrentClasspathUpdatesListener.schedule(job);
        return job;
    }

    private static class DuplicateJobListener
    extends JobChangeAdapter
    implements IJobChangeListener {
        private DuplicateJobListener() {
        }

        public void done(IJobChangeEvent event) {
            SCHEDULED_PROJECTS.remove(((ServerClasspathContainerUpdateJob)event.getJob()).getJavaProject());
        }

        public void scheduled(IJobChangeEvent event) {
            SCHEDULED_PROJECTS.add(((ServerClasspathContainerUpdateJob)event.getJob()).getJavaProject());
        }
    }

    private static class LimitConcurrentClasspathUpdatesListener
    extends JobChangeAdapter
    implements IJobChangeListener {
        private final Queue<ServerClasspathContainerUpdateJob> SCHEDULED_JOBS = new LinkedBlockingQueue<ServerClasspathContainerUpdateJob>();
        private int maxNrOfConcurrentJobs = Runtime.getRuntime().availableProcessors();
        private AtomicInteger nrOfBuildingProjects = new AtomicInteger(0);

        private LimitConcurrentClasspathUpdatesListener() {
        }

        public void done(IJobChangeEvent event) {
            this.nrOfBuildingProjects.decrementAndGet();
            this.startNextJob();
        }

        public void running(IJobChangeEvent event) {
            ServerClasspathContainerUpdateJob job = (ServerClasspathContainerUpdateJob)event.getJob();
            StatusManager.getManager().handle((IStatus)new Status(1, "org.eclipse.virgo.ide.jdt.core", "Updating classpath of: " + job.javaProject.getProject().getName() + ". Queue size: " + this.SCHEDULED_JOBS.size()));
        }

        public void scheduled(IJobChangeEvent event) {
            this.nrOfBuildingProjects.incrementAndGet();
        }

        private void schedule(ServerClasspathContainerUpdateJob job) {
            this.SCHEDULED_JOBS.offer(job);
            this.startNextJob();
        }

        private void startNextJob() {
            Job job;
            if (this.nrOfBuildingProjects.get() < this.maxNrOfConcurrentJobs && (job = (Job)this.SCHEDULED_JOBS.poll()) != null) {
                job.schedule();
            }
        }
    }
}

