/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors.text;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.virgo.ide.ui.editors.text.AbstractPdeManifestConfiguration;
import org.eclipse.virgo.ide.ui.editors.text.BundleManifestContentAssistProcessor;
import org.eclipse.virgo.ide.ui.editors.text.JFaceDefaultInformationControl;

public class BundleManifestConfiguration
extends AbstractPdeManifestConfiguration {
    private BundleManifestContentAssistProcessor fContentAssistantProcessor;

    public BundleManifestConfiguration(IColorManager manager) {
        this(manager, null, null);
    }

    public BundleManifestConfiguration(IColorManager manager, PDESourcePage page) {
        this(manager, page, null);
    }

    public BundleManifestConfiguration(IColorManager manager, PDESourcePage page, String documentPartitioning) {
        super(manager, page, documentPartitioning);
        this.fPropertyKeyScanner = new BundleManifestHeaderScanner();
        this.fPropertyValueScanner = new BundleManifestValueScanner();
    }

    public void dispose() {
        if (this.fQuickAssistant != null) {
            this.fQuickAssistant.dispose();
        }
        if (this.fContentAssistant != null) {
            this.fContentAssistantProcessor.dispose();
        }
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fSourcePage != null && this.fSourcePage.isEditable()) {
            if (this.fContentAssistant == null) {
                this.fContentAssistant = new ContentAssistant();
                this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
                this.fContentAssistantProcessor = new BundleManifestContentAssistProcessor(this.fSourcePage);
                this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fContentAssistantProcessor, "__dftl_partition_content_type");
                this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fContentAssistantProcessor, "__mf_bundle_header_value");
                this.fContentAssistant.addCompletionListener((ICompletionListener)this.fContentAssistantProcessor);
                this.fContentAssistant.setInformationControlCreator(new IInformationControlCreator(){

                    public IInformationControl createInformationControl(Shell parent) {
                        return new JFaceDefaultInformationControl(parent, false);
                    }
                });
                this.fContentAssistant.setContextInformationPopupOrientation(20);
            }
            return this.fContentAssistant;
        }
        return null;
    }

    protected class BundleManifestHeaderScanner
    extends AbstractPdeManifestConfiguration.ManifestHeaderScanner {
        private Token springToken;

        public boolean affectsTextPresentation(String property) {
            if (property.startsWith("editor.color.header_spring")) {
                return true;
            }
            return super.affectsTextPresentation(property);
        }

        protected Token getTokenAffected(PropertyChangeEvent event) {
            if (event.getProperty().startsWith("editor.color.header_spring")) {
                return this.springToken;
            }
            return super.getTokenAffected(event);
        }

        protected void initialize() {
            this.fToken = new Token((Object)this.createTextAttribute("editor.color.header_osgi"));
            this.springToken = new Token((Object)this.createTextAttribute("editor.color.header_spring"));
            WordRule rule = new WordRule((IWordDetector)new AbstractPdeManifestConfiguration.KeywordDetector(), Token.UNDEFINED, true);
            rule.addWord("Bundle-Activator", (IToken)this.fToken);
            rule.addWord("Bundle-Category", (IToken)this.fToken);
            rule.addWord("Bundle-ClassPath", (IToken)this.fToken);
            rule.addWord("Bundle-ContactAddress", (IToken)this.fToken);
            rule.addWord("Bundle-Copyright", (IToken)this.fToken);
            rule.addWord("Bundle-Description", (IToken)this.fToken);
            rule.addWord("Bundle-DocURL", (IToken)this.fToken);
            rule.addWord("Bundle-Localization", (IToken)this.fToken);
            rule.addWord("Bundle-ManifestVersion", (IToken)this.fToken);
            rule.addWord("Bundle-Name", (IToken)this.fToken);
            rule.addWord("Bundle-NativeCode", (IToken)this.fToken);
            rule.addWord("Bundle-RequiredExecutionEnvironment", (IToken)this.fToken);
            rule.addWord("Bundle-SymbolicName", (IToken)this.fToken);
            rule.addWord("Bundle-UpdateLocation", (IToken)this.fToken);
            rule.addWord("Bundle-Vendor", (IToken)this.fToken);
            rule.addWord("Bundle-Version", (IToken)this.fToken);
            rule.addWord("Require-Bundle", (IToken)this.fToken);
            rule.addWord("DynamicImport-Package", (IToken)this.fToken);
            rule.addWord("Export-Package", (IToken)this.fToken);
            rule.addWord("Export-Service", (IToken)this.fToken);
            rule.addWord("Fragment-Host", (IToken)this.fToken);
            rule.addWord("Import-Package", (IToken)this.fToken);
            rule.addWord("Import-Service", (IToken)this.fToken);
            rule.addWord("Provide-Package", (IToken)this.fToken);
            this.addRulesForHeaders(rule);
            this.setRules(new IRule[]{rule});
            this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute("editor.color.header_key")));
        }

        private void addRulesForHeaders(WordRule rule) {
            ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.virgo.ide.ui.editors.text.headers");
            Enumeration<String> headers = bundle.getKeys();
            while (headers.hasMoreElements()) {
                rule.addWord(headers.nextElement(), (IToken)this.springToken);
            }
        }
    }

    protected class BundleManifestValueScanner
    extends AbstractPdeManifestConfiguration.ManifestValueScanner {
        protected void initialize() {
            IRule[] rules = new IRule[2];
            this.fAssignmentToken = new Token((Object)this.createTextAttribute("editor.color.header_assignment"));
            rules[0] = new WordRule((IWordDetector)new AbstractPdeManifestConfiguration.AssignmentDetector(), (IToken)this.fAssignmentToken);
            this.fAttributeToken = new Token((Object)this.createTextAttribute("editor.color.header_attributes"));
            WordRule rule = new WordRule((IWordDetector)new AbstractPdeManifestConfiguration.KeywordDetector());
            rule.addWord("language", (IToken)this.fAttributeToken);
            rule.addWord("osname", (IToken)this.fAttributeToken);
            rule.addWord("osversion", (IToken)this.fAttributeToken);
            rule.addWord("processor", (IToken)this.fAttributeToken);
            rule.addWord("bundle-symbolic-name", (IToken)this.fAttributeToken);
            rule.addWord("bundle-version", (IToken)this.fAttributeToken);
            rule.addWord("exclude", (IToken)this.fAttributeToken);
            rule.addWord("fragment-attachment", (IToken)this.fAttributeToken);
            rule.addWord("include", (IToken)this.fAttributeToken);
            rule.addWord("mandatory", (IToken)this.fAttributeToken);
            rule.addWord("resolution", (IToken)this.fAttributeToken);
            rule.addWord("singleton", (IToken)this.fAttributeToken);
            rule.addWord("uses", (IToken)this.fAttributeToken);
            rule.addWord("version", (IToken)this.fAttributeToken);
            rule.addWord("visibility", (IToken)this.fAttributeToken);
            rule.addWord("x-friends", (IToken)this.fAttributeToken);
            rule.addWord("x-internal", (IToken)this.fAttributeToken);
            rule.addWord("specification-version", (IToken)this.fAttributeToken);
            String[] stringArray = ICoreConstants.EE_TOKENS;
            int n = ICoreConstants.EE_TOKENS.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                rule.addWord(element, (IToken)this.fAttributeToken);
                ++n2;
            }
            this.addRulesForAttributes(rule);
            rules[1] = rule;
            this.setRules(rules);
            this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute("editor.color.header_value")));
        }

        private void addRulesForAttributes(WordRule rule) {
            ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.virgo.ide.ui.editors.text.attributes");
            Enumeration<String> attributes = bundle.getKeys();
            while (attributes.hasMoreElements()) {
                rule.addWord(attributes.nextElement(), (IToken)this.fAttributeToken);
            }
        }
    }
}

