/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import org.eclipse.virgo.util.osgi.manifest.BundleManifest;

final class WebContainerUtils {
    private static final String WAR_HEADER = "org-eclipse-virgo-web-war-detected";
    private static final String DEFAULTED_BSN = "org-eclipse-virgo-kernel-DefaultedBSN";

    WebContainerUtils() {
    }

    public static boolean isWebApplicationBundle(BundleManifest manifest) {
        return !WebContainerUtils.isWar(manifest) && (WebContainerUtils.specifiesBundleSymbolicName(manifest) || WebContainerUtils.specifiesBundleVersion(manifest) || WebContainerUtils.specifiesBundleManifestVersion(manifest) || WebContainerUtils.specifiesImportPackage(manifest) || WebContainerUtils.specifiesWebContextPath(manifest));
    }

    private static boolean isWar(BundleManifest manifest) {
        return manifest.getHeader(WAR_HEADER) != null;
    }

    private static boolean specifiesBundleSymbolicName(BundleManifest manifest) {
        if (manifest.getHeader(DEFAULTED_BSN) != null) {
            return false;
        }
        return manifest.getBundleSymbolicName().getSymbolicName() != null;
    }

    private static boolean specifiesBundleVersion(BundleManifest manifest) {
        return manifest.getHeader("Bundle-Version") != null;
    }

    private static boolean specifiesBundleManifestVersion(BundleManifest manifest) {
        return manifest.getBundleManifestVersion() != 1;
    }

    private static boolean specifiesImportPackage(BundleManifest manifest) {
        return !manifest.getImportPackage().getImportedPackages().isEmpty();
    }

    private static boolean specifiesWebContextPath(BundleManifest manifest) {
        return manifest.getHeader("Web-ContextPath") != null;
    }
}

