/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent.management;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceInfo;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceStatistics;

public class StandardExecutorServiceInfo
implements ExecutorServiceInfo {
    private final Reference<ExecutorServiceStatistics> managedExecutorService;

    public StandardExecutorServiceInfo(ExecutorServiceStatistics service) {
        this.managedExecutorService = new WeakReference<ExecutorServiceStatistics>(service);
    }

    @Override
    public long getAverageExecutionTime() {
        ExecutorServiceStatistics executorService = this.managedExecutorService.get();
        return executorService == null ? -1L : executorService.getAverageExecutionTime();
    }

    @Override
    public long getExecutionTime() {
        ExecutorServiceStatistics executorService = this.managedExecutorService.get();
        return executorService == null ? -1L : executorService.getExecutionTime();
    }

    @Override
    public int getPoolSize() {
        ExecutorServiceStatistics executorService = this.managedExecutorService.get();
        return executorService == null ? -1 : executorService.getPoolSize();
    }

    @Override
    public int getLargestPoolSize() {
        ExecutorServiceStatistics executorService = this.managedExecutorService.get();
        return executorService == null ? -1 : executorService.getLargestPoolSize();
    }

    @Override
    public String getTypeName() {
        ExecutorServiceStatistics executorService = this.managedExecutorService.get();
        if (executorService == null) {
            return null;
        }
        return executorService instanceof ScheduledExecutorService ? ScheduledExecutorService.class.getSimpleName() : ExecutorService.class.getSimpleName();
    }

    @Override
    public int getActiveCount() {
        ExecutorServiceStatistics executorService = this.managedExecutorService.get();
        return executorService == null ? -1 : executorService.getActiveCount();
    }

    @Override
    public int getMaximumPoolSize() {
        ExecutorServiceStatistics executorService = this.managedExecutorService.get();
        return executorService == null ? -1 : executorService.getMaximumPoolSize();
    }
}

