/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactDescriptorPersister;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.IndexFormatException;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.UriMapper;
import org.eclipse.virgo.repository.configuration.LocalRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.BaseRepository;
import org.eclipse.virgo.repository.internal.DelegatingRepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.RepositoryLogEvents;
import org.eclipse.virgo.repository.internal.StandardArtifactDescriptorDepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalRepository
extends BaseRepository {
    private static final Logger LOGGER;
    private final Set<ArtifactBridge> artifactBridges;
    private final UriMapper mapper;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.LocalRepository");
        LOGGER = LoggerFactory.getLogger(LocalRepository.class);
    }

    protected LocalRepository(LocalRepositoryConfiguration configuration, ArtifactDescriptorPersister artifactDescriptorPersister, EventLogger eventLogger) throws IndexFormatException {
        super(configuration, new StandardArtifactDescriptorDepository(artifactDescriptorPersister));
        this.eventLogger = eventLogger;
        this.mapper = configuration.getUriMapper();
        this.artifactBridges = new HashSet<ArtifactBridge>(configuration.getArtefactBridges());
    }

    protected RepositoryAwareArtifactDescriptor createArtifactDescriptor(File artifactFile) {
        boolean seenFailure = false;
        for (ArtifactBridge artifactBridge : this.artifactBridges) {
            try {
                ArtifactDescriptor artifactDescriptor = artifactBridge.generateArtifactDescriptor(artifactFile);
                if (artifactDescriptor == null) continue;
                if (seenFailure) {
                    LOGGER.debug("ArtifactBridge '{}' rescued artifact '{}'.", (Object)artifactBridge, (Object)artifactFile);
                    this.eventLogger.log((LogEvent)RepositoryLogEvents.ARTIFACT_RECOVERED, new Object[]{artifactFile.getName(), this.getName()});
                }
                return new DelegatingRepositoryAwareArtifactDescriptor(artifactDescriptor, this.getName(), this.mapper);
            }
            catch (ArtifactGenerationException age) {
                LOGGER.error(String.format("ArtifactBridge '%s' failed to generate descriptor for artifact '%s'.", artifactBridge, artifactFile), (Throwable)age);
                this.eventLogger.log((LogEvent)RepositoryLogEvents.BRIDGE_PARSE_FAILURE, new Object[]{artifactFile.getName(), age.getArtifactType(), this.getName()});
                seenFailure = true;
            }
            catch (Exception e) {
                LOGGER.error(String.format("ArtifactBridge '%s' threw unexpected execption for artifact '%s'.", artifactBridge, artifactFile), (Throwable)e);
                this.eventLogger.log((LogEvent)RepositoryLogEvents.BRIDGE_UNEXPECTED_EXCEPTION, new Object[]{artifactFile.getName(), this.getName()});
                seenFailure = true;
            }
        }
        return null;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

