/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.config.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KernelConfiguration {
    private final Logger LOGGER;
    static final String PROPERTY_KERNEL_CONFIG = "org.eclipse.virgo.kernel.config";
    static final String PROPERTY_KERNEL_HOME = "org.eclipse.virgo.kernel.home";
    static final String PROPERTY_KERNEL_DOMAIN = "org.eclipse.virgo.kernel.domain";
    static final String PROPERTY_KERNEL_STARTUP_WAIT_LIMIT = "org.eclipse.virgo.kernel.startup.wait.limit";
    private static final String DEFAULT_WORK_DIRECTORY_NAME = "work";
    private static final String DEFAULT_CONFIG_DIRECTORY_NAME = "config";
    private static final String DEFAULT_KERNEL_DOMAIN = "org.eclipse.virgo.kernel";
    private static final int DEFAULT_STARTUP_WAIT_LIMIT = 180;
    private final File homeDirectory;
    private final File[] configDirectories;
    private final File workDirectory;
    private final String domain;
    private final int startupWaitLimit;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public KernelConfiguration(BundleContext context) {
        try {
            this.LOGGER = LoggerFactory.getLogger(this.getClass());
            this.homeDirectory = KernelConfiguration.readHomeDirectory(context);
            this.configDirectories = KernelConfiguration.readConfigDirectories(context);
            this.workDirectory = new File(this.homeDirectory, DEFAULT_WORK_DIRECTORY_NAME);
            this.domain = KernelConfiguration.readDomain(context);
            this.startupWaitLimit = this.readBundleStartupWaitLimit(context);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public File getHomeDirectory() {
        try {
            return this.homeDirectory;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public File[] getConfigDirectories() {
        try {
            return (File[])this.configDirectories.clone();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public File getWorkDirectory() {
        try {
            return this.workDirectory;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public String getDomain() {
        try {
            return this.domain;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public int getStartupWaitLimit() {
        try {
            return this.startupWaitLimit;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static File readHomeDirectory(BundleContext context) {
        try {
            File file;
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            try {
                String kernelHomeProperty = KernelConfiguration.readFrameworkProperty(PROPERTY_KERNEL_HOME, context);
                if (!KernelConfiguration.hasText(kernelHomeProperty)) {
                    throw new IllegalStateException("org.eclipse.virgo.kernel.home property must be specified, and must not be empty");
                }
                file = new File(kernelHomeProperty);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return file;
        }
        catch (Throwable throwable) {
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private static File[] readConfigDirectories(BundleContext context) {
        try {
            File[] fileArray;
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                String kernelConfigProperty = KernelConfiguration.readFrameworkProperty(PROPERTY_KERNEL_CONFIG, context);
                ArrayList<File> configDirectories = new ArrayList<File>();
                if (KernelConfiguration.hasText(kernelConfigProperty)) {
                    KernelConfiguration.parseKernelConfigProperty(kernelConfigProperty, configDirectories);
                }
                if (configDirectories.isEmpty()) {
                    configDirectories.add(new File(DEFAULT_CONFIG_DIRECTORY_NAME));
                }
                fileArray = configDirectories.toArray(new File[configDirectories.size()]);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return fileArray;
        }
        catch (Throwable throwable) {
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private static void parseKernelConfigProperty(String kernelConfigProperty, List<File> configDirectories) {
        try {
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                String[] components;
                String[] stringArray = components = kernelConfigProperty.split(",");
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    String component = stringArray[n2];
                    File configDir = new File(component.trim());
                    if (!configDir.isAbsolute()) {
                        configDir = new File(component.trim());
                    }
                    configDirectories.add(configDir);
                    ++n2;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private static String readDomain(BundleContext context) {
        try {
            String string;
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                String kernelDomainProperty = KernelConfiguration.readFrameworkProperty(PROPERTY_KERNEL_DOMAIN, context);
                if (!KernelConfiguration.hasText(kernelDomainProperty)) {
                    kernelDomainProperty = DEFAULT_KERNEL_DOMAIN;
                }
                string = kernelDomainProperty;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return string;
        }
        catch (Throwable throwable) {
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private int readBundleStartupWaitLimit(BundleContext context) {
        try {
            int n;
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                String waitLimitProperty = KernelConfiguration.readFrameworkProperty(PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, context);
                if (!KernelConfiguration.hasText(waitLimitProperty)) {
                    n = 180;
                } else {
                    try {
                        n = Integer.parseInt(waitLimitProperty);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.LOGGER.warn("Could not parse property {} with value '{}'. Using default limit {} seconds", new Object[]{PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, waitLimitProperty, 180});
                        n = 180;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return n;
        }
        catch (Throwable throwable) {
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private static String readFrameworkProperty(String propertyKey, BundleContext context) {
        try {
            String string;
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            try {
                string = context.getProperty(propertyKey);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return string;
        }
        catch (Throwable throwable) {
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private static boolean hasText(String string) {
        try {
            boolean bl;
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            try {
                bl = string != null && !string.trim().isEmpty();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return bl;
        }
        catch (Throwable throwable) {
            KernelConfiguration.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("KernelConfiguration.java", Class.forName("org.eclipse.virgo.kernel.config.internal.KernelConfiguration"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "readHomeDirectory", "org.eclipse.virgo.kernel.config.internal.KernelConfiguration", "org.osgi.framework.BundleContext:", "context:", "", "java.io.File"), 80);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "readConfigDirectories", "org.eclipse.virgo.kernel.config.internal.KernelConfiguration", "org.osgi.framework.BundleContext:", "context:", "", "[Ljava.io.File;"), 89);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "parseKernelConfigProperty", "org.eclipse.virgo.kernel.config.internal.KernelConfiguration", "java.lang.String:java.util.List:", "kernelConfigProperty:configDirectories:", "", "void"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "readDomain", "org.eclipse.virgo.kernel.config.internal.KernelConfiguration", "org.osgi.framework.BundleContext:", "context:", "", "java.lang.String"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readBundleStartupWaitLimit", "org.eclipse.virgo.kernel.config.internal.KernelConfiguration", "org.osgi.framework.BundleContext:", "context:", "", "int"), 123);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "readFrameworkProperty", "org.eclipse.virgo.kernel.config.internal.KernelConfiguration", "java.lang.String:org.osgi.framework.BundleContext:", "propertyKey:context:", "", "java.lang.String"), 138);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "hasText", "org.eclipse.virgo.kernel.config.internal.KernelConfiguration", "java.lang.String:", "string:", "", "boolean"), 142);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.config.internal.KernelConfiguration");
    }
}

