/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.internal;

import org.eclipse.virgo.util.osgi.manifest.ImportedLibrary;
import org.eclipse.virgo.util.osgi.manifest.Sharing;
import org.eclipse.virgo.util.osgi.manifest.internal.BaseImported;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;

public class StandardImportedLibrary
extends BaseImported
implements ImportedLibrary {
    private static final String SHARING_SHARE = "share";
    private static final String SHARING_CLONE = "clone";
    private static final String SHARING_DIRECTIVE = "sharing";

    StandardImportedLibrary(HeaderParser parser, String name) {
        super(parser, name);
    }

    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        return parser.parseImportLibraryHeader(parseString).get(0);
    }

    public String getLibrarySymbolicName() {
        return this.name;
    }

    public void setLibrarySymbolicName(String librarySymbolicName) {
        if (librarySymbolicName == null) {
            throw new IllegalArgumentException("librarySymbolicName must not be null");
        }
        this.name = librarySymbolicName;
    }

    public Sharing getSharing() {
        String value = this.getDirectives().get(SHARING_DIRECTIVE);
        if (SHARING_SHARE.equals(value)) {
            return Sharing.SHARE;
        }
        if (SHARING_CLONE.equals(value)) {
            return Sharing.CLONE;
        }
        return Sharing.AUTOMATIC;
    }

    public void setSharing(Sharing sharing) {
        if (sharing == null) {
            this.getDirectives().remove(SHARING_DIRECTIVE);
            return;
        }
        switch (sharing) {
            case CLONE: {
                this.getDirectives().put(SHARING_DIRECTIVE, SHARING_CLONE);
                break;
            }
            case SHARE: {
                this.getDirectives().put(SHARING_DIRECTIVE, SHARING_SHARE);
                break;
            }
            default: {
                this.getDirectives().remove(SHARING_DIRECTIVE);
            }
        }
    }
}

