/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.security.auth.Subject;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.SubjectSource;

public class SubjectInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final SubjectSource subjectSource;

    public SubjectInterceptor(ConnectionInterceptor next, SubjectSource subjectSource) {
        this.next = next;
        this.subjectSource = subjectSource;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        ManagedConnectionInfo originalManagedConnectionInfo;
        Subject currentSubject = null;
        if (!connectionInfo.isApplicationManagedSecurity()) {
            try {
                currentSubject = this.subjectSource.getSubject();
            }
            catch (SecurityException e) {
                throw new ResourceException("Can not obtain Subject for login", (Throwable)e);
            }
            if (currentSubject == null) {
                throw new ResourceException("No subject for container managed security");
            }
        }
        if ((originalManagedConnectionInfo = connectionInfo.getManagedConnectionInfo()).getManagedConnection() == null) {
            originalManagedConnectionInfo.setSubject(currentSubject);
            this.next.getConnection(connectionInfo);
        } else {
            Subject oldSubject = originalManagedConnectionInfo.getSubject();
            if (currentSubject == null ? oldSubject != null : !currentSubject.equals(oldSubject)) {
                if (connectionInfo.isUnshareable()) {
                    throw new ApplicationServerInternalException("Unshareable resource is attempting to change security context: expected request under: " + oldSubject + ", received request under: " + currentSubject);
                }
                ConnectionInfo returningConnectionInfo = new ConnectionInfo();
                returningConnectionInfo.setManagedConnectionInfo(originalManagedConnectionInfo);
                returningConnectionInfo.setConnectionHandle(connectionInfo.getConnectionHandle());
                ManagedConnectionInfo newManagedConnectionInfo = new ManagedConnectionInfo(originalManagedConnectionInfo.getManagedConnectionFactory(), originalManagedConnectionInfo.getConnectionRequestInfo());
                newManagedConnectionInfo.setSubject(currentSubject);
                connectionInfo.setManagedConnectionInfo(newManagedConnectionInfo);
                this.next.getConnection(connectionInfo);
                this.returnConnection(returningConnectionInfo, ConnectionReturnAction.RETURN_HANDLE);
            } else {
                this.next.getConnection(connectionInfo);
            }
        }
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    public void destroy() {
        this.next.destroy();
    }

    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[subjectSource=").append(this.subjectSource).append("]\n");
        this.next.info(s);
    }
}

