/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.rmi.server.ObjID;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class RemoteScrollableCursor
extends ScrollableCursor {
    protected ObjID id = new ObjID();
    protected boolean isClosed;

    public RemoteScrollableCursor(ScrollableCursor serverScrollableCursor) {
        this.isClosed = serverScrollableCursor.isClosed();
    }

    @Override
    public boolean absolute(int rows) throws DatabaseException {
        this.clearNextAndPrevious();
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorAbsolute(this.getID(), rows);
    }

    @Override
    public void afterLast() throws DatabaseException {
        this.clearNextAndPrevious();
        ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorAfterLast(this.getID());
    }

    @Override
    public void beforeFirst() throws DatabaseException {
        this.clearNextAndPrevious();
        ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorBeforeFirst(this.getID());
    }

    @Override
    public void close() throws DatabaseException {
        if (this.isClosed()) {
            return;
        }
        ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorClose(this.getID());
        this.isClosed = true;
    }

    @Override
    public int currentIndex() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorCurrentIndex(this.getID());
    }

    @Override
    public boolean first() throws DatabaseException {
        this.clearNextAndPrevious();
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorFirst(this.getID());
    }

    @Override
    protected int getCursorSize() {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorSize(this.getID());
    }

    public ObjID getID() {
        return this.id;
    }

    @Override
    public boolean isAfterLast() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorIsAfterLast(this.getID());
    }

    @Override
    public boolean isBeforeFirst() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorIsBeforeFirst(this.getID());
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isFirst() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorIsFirst(this.getID());
    }

    @Override
    public boolean isLast() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorIsLast(this.getID());
    }

    @Override
    public boolean last() throws DatabaseException {
        this.clearNextAndPrevious();
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorLast(this.getID());
    }

    @Override
    public boolean relative(int rows) throws DatabaseException {
        this.clearNextAndPrevious();
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorRelative(this.getID(), rows);
    }

    @Override
    protected Object retrieveNextObject() throws DatabaseException, QueryException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorNextObject(this.getID(), this.getPolicy().getQuery(), (RemoteSession)this.getSession());
    }

    @Override
    protected Object retrievePreviousObject() throws DatabaseException {
        return ((RemoteSession)this.getSession()).getRemoteConnection().scrollableCursorPreviousObject(this.getID(), this.getPolicy().getQuery(), (RemoteSession)this.getSession());
    }
}

