/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.EjbRefType;
import org.apache.openejb.jee.EjbReference;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ejb-refType", propOrder={"descriptions", "ejbRefName", "ejbRefType", "home", "remote", "ejbLink", "mappedName", "injectionTarget", "lookupName"})
public class EjbRef
implements EjbReference {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="ejb-ref-name", required=true)
    protected String ejbRefName;
    @XmlElement(name="ejb-ref-type")
    protected EjbRefType ejbRefType;
    protected String home;
    protected String remote;
    @XmlElement(name="ejb-link")
    protected String ejbLink;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;
    @XmlTransient
    protected EjbReference.Type refType = EjbReference.Type.REMOTE;

    public EjbRef name(String ejbRefName) {
        this.ejbRefName = ejbRefName;
        return this;
    }

    public EjbRef type(EjbRefType ejbRefType) {
        this.ejbRefType = ejbRefType;
        return this;
    }

    public EjbRef link(String link) {
        this.ejbLink = link;
        return this;
    }

    public EjbRef remote(String remote) {
        this.remote = remote;
        return this;
    }

    public EjbRef remote(Class<?> remote) {
        return this.remote(remote.getName());
    }

    public EjbRef home(String home) {
        this.home = home;
        return this;
    }

    public EjbRef home(Class<?> home) {
        return this.home(home.getName());
    }

    public EjbRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public EjbRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public EjbRef injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.ejbRefName == null) {
            this.ejbRefName = "java:comp/env/" + className + "/" + property;
        }
        return this;
    }

    public EjbRef injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    @Override
    public EjbReference.Type getRefType() {
        return this.refType;
    }

    @Override
    public void setRefType(EjbReference.Type refType) {
        this.refType = refType;
    }

    @Override
    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getEjbRefName() {
        return this.ejbRefName;
    }

    @Override
    public String getName() {
        return this.getEjbRefName();
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    @Override
    public String getType() {
        return this.getEjbRefType().name();
    }

    @Override
    public void setName(String name) {
        this.setEjbRefName(name);
    }

    @Override
    public void setType(String type) {
    }

    public void setEjbRefName(String value) {
        this.ejbRefName = value;
    }

    @Override
    public EjbRefType getEjbRefType() {
        return this.ejbRefType;
    }

    public void setEjbRefType(EjbRefType value) {
        this.ejbRefType = value;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    public void setHome(String value) {
        this.home = value;
    }

    public String getRemote() {
        return this.remote;
    }

    @Override
    public String getInterface() {
        return this.getRemote();
    }

    public void setRemote(String value) {
        this.remote = value;
    }

    @Override
    public String getEjbLink() {
        return this.ejbLink;
    }

    public void setEjbLink(String value) {
        this.ejbLink = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "EjbRef{name='" + this.ejbRefName + '\'' + ", remote='" + this.remote + '\'' + ", link='" + this.ejbLink + '\'' + ", mappedName='" + this.mappedName + '\'' + ", lookupName='" + this.lookupName + '\'' + '}';
    }
}

