/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.scoping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.DynamicImportPackage;
import org.eclipse.virgo.util.osgi.manifest.DynamicallyImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.FragmentHost;
import org.eclipse.virgo.util.osgi.manifest.ImportedBundle;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.RequiredBundle;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scoper {
    private static final String BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME = "bundle-symbolic-name";
    public static final String SCOPE_SEPARATOR = "-";
    private static final int BUNDLE_MANIFEST_VERSION_FOR_OSGI_R4 = 2;
    private static final String SCOPING_ATTRIBUTE_NAME = "module_scope";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<BundleManifest> bundleManifests;
    private final String scopeName;
    private final String scopePrefix;
    private final Map<String, Version> exportedPackages = new HashMap<String, Version>();
    private final Map<String, Version> bundles = new HashMap<String, Version>();

    public Scoper(List<BundleManifest> bundleManifests, String scopeName) {
        this.bundleManifests = bundleManifests;
        this.scopeName = scopeName;
        this.scopePrefix = String.valueOf(scopeName) + SCOPE_SEPARATOR;
    }

    public void scope() throws UnsupportedBundleManifestVersionException, DuplicateExportException, DuplicateBundleSymbolicNameException {
        this.scopeReferents();
        this.scopeReferences();
    }

    private void scopeReferents() throws UnsupportedBundleManifestVersionException, DuplicateExportException, DuplicateBundleSymbolicNameException {
        for (BundleManifest bundleManifest : this.bundleManifests) {
            this.scopeBundleReferents(bundleManifest, true);
        }
    }

    private void scopeBundleReferents(BundleManifest bundleManifest, boolean allowDuplicates) throws UnsupportedBundleManifestVersionException, DuplicateExportException, DuplicateBundleSymbolicNameException {
        this.logger.debug("Bundle manifest before scoping:\n{}", (Object)bundleManifest);
        if (bundleManifest.getBundleManifestVersion() < 2) {
            throw new UnsupportedBundleManifestVersionException();
        }
        for (ExportedPackage exportedPackage : bundleManifest.getExportPackage().getExportedPackages()) {
            this.scopeExportedPackage(exportedPackage, allowDuplicates);
        }
        this.setModuleScope(bundleManifest);
        String symbolicName = bundleManifest.getBundleSymbolicName().getSymbolicName();
        if (symbolicName.startsWith(this.scopeName)) {
            symbolicName = symbolicName.substring(this.scopeName.length() + 1);
        }
        this.bundles.put(symbolicName, bundleManifest.getBundleVersion());
    }

    private void setModuleScope(BundleManifest bundleManifest) {
        bundleManifest.setModuleScope(this.scopeName);
    }

    private void scopeExportedPackage(ExportedPackage exportedPackage, boolean allowDuplicates) throws DuplicateExportException, UnsupportedBundleManifestVersionException {
        exportedPackage.getAttributes().put(SCOPING_ATTRIBUTE_NAME, this.scopeName);
        exportedPackage.getMandatory().add(SCOPING_ATTRIBUTE_NAME);
        Version packageVersion = exportedPackage.getVersion();
        if (this.exportedPackages.containsKey(exportedPackage.getPackageName())) {
            if (!allowDuplicates) {
                this.diagnoseDuplicateExport(exportedPackage.getPackageName());
            }
        } else {
            this.exportedPackages.put(exportedPackage.getPackageName(), packageVersion);
        }
    }

    private void diagnoseDuplicateExport(String packageName) throws DuplicateExportException, UnsupportedBundleManifestVersionException {
        StringBuffer exporters = new StringBuffer();
        boolean first = true;
        for (BundleManifest bundleManifest : this.bundleManifests) {
            if (bundleManifest.getBundleManifestVersion() < 2) {
                throw new UnsupportedBundleManifestVersionException();
            }
            for (ExportedPackage exportedPackage : bundleManifest.getExportPackage().getExportedPackages()) {
                if (!packageName.equals(exportedPackage.getPackageName())) continue;
                if (!first) {
                    exporters.append(", ");
                }
                first = false;
                exporters.append(Scoper.getUnscopedSymbolicName(bundleManifest));
                exporters.append(" ");
                exporters.append(bundleManifest.getBundleVersion());
            }
        }
        throw new DuplicateExportException(packageName, exporters.toString());
    }

    public static String getUnscopedSymbolicName(BundleManifest bundleManifest) {
        String symbolicName = null;
        BundleSymbolicName bundleSymbolicName = bundleManifest.getBundleSymbolicName();
        if (bundleSymbolicName != null) {
            String scopeName;
            symbolicName = bundleSymbolicName.getSymbolicName();
            String moduleScope = bundleManifest.getModuleScope();
            if (moduleScope != null && symbolicName.startsWith(scopeName = String.valueOf(moduleScope) + SCOPE_SEPARATOR)) {
                symbolicName = symbolicName.substring(scopeName.length());
            }
        }
        return symbolicName;
    }

    public String getUnscopedSymbolicName(String bundleSymbolicName) {
        String symbolicName = null;
        if (bundleSymbolicName != null && (symbolicName = bundleSymbolicName).startsWith(this.scopePrefix)) {
            symbolicName = symbolicName.substring(this.scopePrefix.length());
        }
        return symbolicName;
    }

    public String getScopedSymbolicName(String bundleSymbolicName) {
        String symbolicName = this.getUnscopedSymbolicName(bundleSymbolicName);
        if (this.bundles.containsKey(symbolicName)) {
            return String.valueOf(this.scopePrefix) + symbolicName;
        }
        return bundleSymbolicName;
    }

    private void scopeReferences() {
        for (BundleManifest bundleManifest : this.bundleManifests) {
            this.scopeBundleReferences(bundleManifest);
        }
    }

    private void scopeBundleReferences(BundleManifest bundleManifest) {
        for (ImportedPackage importedPackage : bundleManifest.getImportPackage().getImportedPackages()) {
            this.scopeImportedPackage(importedPackage);
        }
        this.scopeDynamicImports(bundleManifest);
        this.scopeImportBundle(bundleManifest);
        this.scopeRequireBundle(bundleManifest);
        this.scopeFragmentHost(bundleManifest);
        this.logger.debug("Bundle manifest after scoping:\n{}", (Object)bundleManifest);
    }

    private void scopeDynamicImports(BundleManifest bundleManifest) {
        DynamicImportPackage unscopedList = BundleManifestFactory.createBundleManifest().getDynamicImportPackage();
        List dynamicallyImportedPackages = bundleManifest.getDynamicImportPackage().getDynamicallyImportedPackages();
        for (DynamicallyImportedPackage dynamicallyImportedPackage : dynamicallyImportedPackages) {
            this.scopeDynamicallyImportedPackage(dynamicallyImportedPackage);
            this.addUnscopedDynamicallyImportedPackage(unscopedList, dynamicallyImportedPackage);
        }
        dynamicallyImportedPackages.addAll(unscopedList.getDynamicallyImportedPackages());
    }

    private void addUnscopedDynamicallyImportedPackage(DynamicImportPackage unscopedList, DynamicallyImportedPackage dynamicallyImportedPackage) {
        unscopedList.addDynamicallyImportedPackage(dynamicallyImportedPackage.getPackageName());
        List unscopedDynamicallyImportedPackages = unscopedList.getDynamicallyImportedPackages();
        DynamicallyImportedPackage unscopedDIP = (DynamicallyImportedPackage)unscopedDynamicallyImportedPackages.get(unscopedDynamicallyImportedPackages.size() - 1);
        Map attributes = unscopedDIP.getAttributes();
        attributes.putAll(dynamicallyImportedPackage.getAttributes());
        attributes.remove(SCOPING_ATTRIBUTE_NAME);
    }

    private void scopeImportedPackage(ImportedPackage importedPackage) {
        Version exportedVersion = this.exportedPackages.get(importedPackage.getPackageName());
        if (exportedVersion != null) {
            VersionRange importVersionRange = importedPackage.getVersion();
            if (importVersionRange.includes(exportedVersion)) {
                String symbolicName;
                importedPackage.getAttributes().put(SCOPING_ATTRIBUTE_NAME, this.scopeName);
                if (importedPackage.getAttributes().containsKey(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME) && this.bundles.containsKey(symbolicName = (String)importedPackage.getAttributes().get(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME))) {
                    importedPackage.getAttributes().put(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME, String.valueOf(this.scopePrefix) + symbolicName);
                }
            } else {
                this.logger.warn("Import of package '{}' was not scoped to scope '{}' as its version range did not include the version of the scoped export of the package", (Object)importedPackage.getPackageName(), (Object)this.scopeName);
            }
        }
    }

    private void scopeDynamicallyImportedPackage(DynamicallyImportedPackage dynamicallyImportedPackage) {
        String symbolicName;
        dynamicallyImportedPackage.getAttributes().put(SCOPING_ATTRIBUTE_NAME, this.scopeName);
        if (dynamicallyImportedPackage.getAttributes().containsKey(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME) && this.bundles.containsKey(symbolicName = (String)dynamicallyImportedPackage.getAttributes().get(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME))) {
            dynamicallyImportedPackage.getAttributes().put(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME, String.valueOf(this.scopePrefix) + symbolicName);
        }
    }

    private void scopeRequireBundle(BundleManifest bundleManifest) {
        List requiredBundles = bundleManifest.getRequireBundle().getRequiredBundles();
        for (RequiredBundle requiredBundle : requiredBundles) {
            String requiredBundleSymbolicName = requiredBundle.getBundleSymbolicName();
            if (!this.bundles.containsKey(requiredBundleSymbolicName)) continue;
            Version version = this.bundles.get(requiredBundleSymbolicName);
            VersionRange requiredVersionRange = requiredBundle.getBundleVersion();
            if (!requiredVersionRange.includes(version)) continue;
            requiredBundle.setBundleSymbolicName(String.valueOf(this.scopePrefix) + requiredBundleSymbolicName);
        }
    }

    private void scopeImportBundle(BundleManifest bundleManifest) {
        List importedBundles = bundleManifest.getImportBundle().getImportedBundles();
        for (ImportedBundle importedBundle : importedBundles) {
            String importedBundleSymbolicName = importedBundle.getBundleSymbolicName();
            if (!this.bundles.containsKey(importedBundleSymbolicName)) continue;
            Version version = this.bundles.get(importedBundleSymbolicName);
            VersionRange versionRange = importedBundle.getVersion();
            if (!versionRange.includes(version)) continue;
            importedBundle.setBundleSymbolicName(String.valueOf(this.scopePrefix) + importedBundleSymbolicName);
        }
    }

    private void scopeFragmentHost(BundleManifest bundleManifest) {
        FragmentHost fragmentHost = bundleManifest.getFragmentHost();
        String bundleSymbolicName = fragmentHost.getBundleSymbolicName();
        if (bundleSymbolicName != null && this.bundles.containsKey(bundleSymbolicName)) {
            fragmentHost.setBundleSymbolicName(String.valueOf(this.scopePrefix) + bundleSymbolicName);
        }
    }

    public static class DuplicateBundleSymbolicNameException
    extends Exception {
        private static final long serialVersionUID = -4228236795055040322L;
        private final String bundleSymbolicName;

        public DuplicateBundleSymbolicNameException(String bundleSymbolicName) {
            this.bundleSymbolicName = bundleSymbolicName;
        }

        public String getBundleSymbolicName() {
            return this.bundleSymbolicName;
        }
    }

    public static class DuplicateExportException
    extends Exception {
        private static final long serialVersionUID = -6672058951941449763L;
        private final String packageName;
        private final String exporters;

        private DuplicateExportException(String packageName, String exporters) {
            this.packageName = packageName;
            this.exporters = exporters;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getExporters() {
            return this.exporters;
        }
    }

    public static class UnsupportedBundleManifestVersionException
    extends Exception {
        private static final long serialVersionUID = -282020071571817876L;

        UnsupportedBundleManifestVersionException() {
            super("Cannot scope a bundle which does not specify a bundle manifest version of at least 2");
        }

        public int getLowestSupportedVersion() {
            return 2;
        }
    }
}

