/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.internal.RWTMessages;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.StartupJson;
import org.eclipse.rap.rwt.internal.service.StartupPageTemplate;
import org.eclipse.rap.rwt.internal.theme.QxImage;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupPage {
    private final ApplicationContextImpl applicationContext;
    private final List<String> jsLibraries;
    private String clientJsLibrary;
    StartupPageTemplate startupPageTemplate;

    public StartupPage(ApplicationContextImpl applicationContext) {
        this.applicationContext = applicationContext;
        this.jsLibraries = new ArrayList<String>();
    }

    public void activate() {
        this.startupPageTemplate = new StartupPageTemplate();
    }

    public void deactivate() {
        this.startupPageTemplate = null;
    }

    public void setClientJsLibrary(String location) {
        this.clientJsLibrary = location;
    }

    public void addJsLibrary(String location) {
        this.jsLibraries.add(location);
    }

    void send(HttpServletResponse response) throws IOException {
        StartupPage.setResponseHeaders(response);
        this.startupPageTemplate.writePage(response.getWriter(), new StartupPageValueProvider());
    }

    static void setResponseHeaders(HttpServletResponse response) {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "max-age=0, no-cache, must-revalidate, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    protected void writeTitle(PrintWriter printWriter) {
        this.writeEntryPointProperty(printWriter, "org.eclipse.rap.rwt.webclient.pageTitle");
    }

    protected void writeBody(PrintWriter printWriter) {
        this.writeEntryPointProperty(printWriter, "org.eclipse.rap.rwt.webclient.bodyHtml");
    }

    protected void writeHead(PrintWriter printWriter) {
        Map<String, String> properties = this.getCurrentEntryPointProperties();
        String favIcon = properties.get("org.eclipse.rap.rwt.webclient.favicon");
        if (favIcon != null && favIcon.length() > 0) {
            String pattern = "<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"%1$s\" />";
            String favIocnMarkup = String.format(pattern, this.getResourceLocation(favIcon));
            printWriter.write(favIocnMarkup);
        }
        this.writeEntryPointProperty(printWriter, "org.eclipse.rap.rwt.webclient.additionalHeaders");
    }

    private void writeLibraries(PrintWriter printWriter) {
        this.writeScriptTag(printWriter, this.clientJsLibrary);
        for (String location : this.jsLibraries) {
            this.writeScriptTag(printWriter, location);
        }
    }

    protected void writeScriptTag(PrintWriter printWriter, String libraryLocation) {
        if (libraryLocation != null) {
            printWriter.write("    <script type=\"text/javascript\" src=\"");
            printWriter.write(libraryLocation);
            printWriter.write("\" charset=\"");
            printWriter.write("UTF-8");
            printWriter.write("\"></script>\n");
        }
    }

    protected void writeBackgroundImage(PrintWriter printWriter) {
        printWriter.write(this.getBackgroundImageLocation());
    }

    protected void writeNoScriptMessage(PrintWriter printWriter) {
        String message = RWTMessages.getMessage("NoScriptWarning");
        printWriter.write(message);
    }

    protected void writeAppScript(PrintWriter printWriter) {
        StringBuilder code = new StringBuilder();
        code.append("rwt.remote.MessageProcessor.processMessage( ");
        code.append(StartupJson.get());
        code.append(");");
        printWriter.write(code.toString());
    }

    protected String getBackgroundImageLocation() {
        String result = "";
        QxImage image = this.getBrackgroundImage();
        String resourceName = image.getResourcePath(this.applicationContext);
        if (resourceName != null) {
            result = this.getResourceLocation(resourceName);
        }
        return result;
    }

    protected QxImage getBrackgroundImage() {
        SimpleSelector defaultSelector = SimpleSelector.DEFAULT;
        return (QxImage)ThemeUtil.getCssValue("Display", "background-image", defaultSelector);
    }

    private Map<String, String> getCurrentEntryPointProperties() {
        EntryPointManager entryPointManager = this.applicationContext.getEntryPointManager();
        HttpServletRequest request = ContextProvider.getRequest();
        EntryPointRegistration registration = entryPointManager.getEntryPointRegistration(request);
        return registration.getProperties();
    }

    private String getResourceLocation(String resourceName) {
        return this.applicationContext.getResourceManager().getLocation(resourceName);
    }

    private void writeEntryPointProperty(PrintWriter printWriter, String property) {
        Map<String, String> properties = this.getCurrentEntryPointProperties();
        String title = properties.get(property);
        if (title != null) {
            printWriter.write(title);
        }
    }

    private class StartupPageValueProvider
    implements StartupPageTemplate.VariableWriter {
        private StartupPageValueProvider() {
        }

        public void writeVariable(PrintWriter printWriter, String variableName) {
            if (variableName.equals("libraries")) {
                StartupPage.this.writeLibraries(printWriter);
            } else if (variableName.equals("title")) {
                StartupPage.this.writeTitle(printWriter);
            } else if (variableName.equals("body")) {
                StartupPage.this.writeBody(printWriter);
            } else if (variableName.equals("headers")) {
                StartupPage.this.writeHead(printWriter);
            } else if (variableName.equals("backgroundImage")) {
                StartupPage.this.writeBackgroundImage(printWriter);
            } else if (variableName.equals("noScriptMessage")) {
                StartupPage.this.writeNoScriptMessage(printWriter);
            } else if (variableName.equals("appScript")) {
                StartupPage.this.writeAppScript(printWriter);
            } else {
                throw new IllegalArgumentException("Unsupported variable: " + variableName);
            }
        }
    }
}

