/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rap.rwt.internal.textsize.MeasurementOperator;
import org.eclipse.rap.rwt.internal.textsize.Probe;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.graphics.FontUtil;

public class MeasurementUtil {
    public static void appendStartupTextSizeProbe(ProtocolMessageWriter writer) {
        MeasurementOperator.getInstance().appendStartupTextSizeProbe(writer);
    }

    static JsonArray createItemParamObject(MeasurementItem item) {
        FontData fontData = item.getFontData();
        JsonArray result = new JsonArray().add(MeasurementUtil.getId(item)).add(item.getTextToMeasure()).add(JsonUtil.createJsonArray(ProtocolUtil.parseFontName(fontData.getName()))).add(fontData.getHeight()).add((fontData.getStyle() & 1) != 0).add((fontData.getStyle() & 2) != 0).add(item.getWrapWidth()).add(MeasurementUtil.isMarkup(item.getMode()));
        return result;
    }

    static JsonArray createProbeParamObject(Probe probe) {
        FontData fontData = probe.getFontData();
        JsonArray result = new JsonArray().add(MeasurementUtil.getId(probe)).add(probe.getText()).add(JsonUtil.createJsonArray(ProtocolUtil.parseFontName(fontData.getName()))).add(fontData.getHeight()).add((fontData.getStyle() & 1) != 0).add((fontData.getStyle() & 2) != 0).add(-1).add(true);
        return result;
    }

    static void addItemToMeasure(String toMeasure, Font font, int wrapWidth, int mode) {
        FontData fontData = FontUtil.getData(font);
        MeasurementItem newItem = new MeasurementItem(toMeasure, fontData, wrapWidth, mode);
        MeasurementOperator.getInstance().addItemToMeasure(newItem);
    }

    static String getId(Probe probe) {
        return MeasurementUtil.getId(probe.getFontData());
    }

    static String getId(MeasurementItem item) {
        return "t" + Integer.toString(item.hashCode());
    }

    static String getId(FontData fontData) {
        return "p" + Integer.toString(fontData.hashCode());
    }

    private static boolean isMarkup(int mode) {
        return mode == 2;
    }

    private MeasurementUtil() {
    }
}

