/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.core.internal.project.facet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.jsf.core.internal.JSFCorePlugin;
import org.eclipse.wtp.jsf.core.internal.Messages;

public class JSFUtils {
    public static final String JSF_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
    public static final String JSF_CONFIG_CONTEXT_PARAM = "javax.faces.CONFIG_FILES";
    public static final String JSF_DEFAULT_CONFIG_PATH = "/WEB-INF/faces-config.xml";

    public static WebArtifactEdit getWebArtifactEditForWrite(IProject project) {
        return WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
    }

    public static WebArtifactEdit getWebArtifactEditForRead(IProject project) {
        return WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
    }

    public static Servlet findJSFServlet(WebApp webApp) {
        Servlet servlet = null;
        Iterator it = webApp.getServlets().iterator();
        while (it.hasNext()) {
            servlet = (Servlet)it.next();
            if (!servlet.getWebType().isServletType() ? servlet.getWebType().isJspType() && ((JSPType)servlet.getWebType()).getJspFile().equals(JSF_SERVLET_CLASS) : ((ServletType)servlet.getWebType()).getClassName().equals(JSF_SERVLET_CLASS)) break;
        }
        return servlet;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createConfigFile(String jsfVersion, IPath configPath) {
        FileOutputStream os = null;
        PrintWriter pw = null;
        String QUOTE = new String(new char[]{'\"'});
        try {
            try {
                IPath dirPath = configPath.removeLastSegments(1);
                dirPath.toFile().mkdirs();
                File file = configPath.toFile();
                file.createNewFile();
                os = new FileOutputStream(file);
                pw = new PrintWriter(os);
                pw.write("<?xml version=" + QUOTE + "1.0" + QUOTE + " encoding=" + QUOTE + "UTF-8" + QUOTE + "?>\n\n");
                if (jsfVersion.equals("1.1")) {
                    pw.write("<!DOCTYPE faces-config PUBLIC\n");
                    pw.write("    " + QUOTE + "-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN" + QUOTE + "\n");
                    pw.write("    " + QUOTE + "http://java.sun.com/dtd/web-facesconfig_1_1.dtd" + QUOTE + ">\n\n");
                    pw.write("<faces-config>\n\n");
                    pw.write("</faces-config>\n");
                } else if (jsfVersion.equals("1.2")) {
                    pw.write("<faces-config\n");
                    pw.write("    xmlns=" + QUOTE + "http://java.sun.com/xml/ns/j2ee" + QUOTE + "\n");
                    pw.write("    xmlns:xsi=" + QUOTE + "http://www.w3.org/2001/XMLSchema-instance" + QUOTE + "\n");
                    pw.write("    xsi:schemaLocation=" + QUOTE + "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-facesconfig_1_2.xsd" + QUOTE + "\n");
                    pw.write("    version=" + QUOTE + "1.2" + QUOTE + ">\n\n");
                    pw.write("</faces-config>\n");
                }
                pw.close();
                pw = null;
            }
            catch (FileNotFoundException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
            }
            catch (IOException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (pw != null) {
                pw.close();
            }
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e);
            }
            throw throwable;
        }
        {
            Object var7_11 = null;
            if (pw != null) {
                pw.close();
            }
            if (os == null) return;
        }
        try {}
        catch (IOException e) {
            JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e);
            return;
        }
        os.close();
    }

    public static Servlet createOrUpdateServletRef(WebApp webApp, IDataModel config, Servlet servlet) {
        String displayName = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        if (servlet == null) {
            servlet = WebapplicationFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(JSF_SERVLET_CLASS);
            servlet.setWebType((WebType)servletType);
            servlet.setLoadOnStartup(new Integer(1));
            webApp.getServlets().add((Object)servlet);
        } else {
            servlet.setServletName(displayName);
            servlet.setLoadOnStartup(new Integer(1));
        }
        return servlet;
    }

    public static void setUpURLMappings(WebApp webApp, List urlMappingList, Servlet servlet) {
        Iterator it = urlMappingList.iterator();
        while (it.hasNext()) {
            String pattern = (String)it.next();
            ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            mapping.setServlet(servlet);
            mapping.setName(servlet.getServletName());
            mapping.setUrlPattern(pattern);
            webApp.getServletMappings().add((Object)mapping);
        }
    }

    public static void removeURLMappings(WebApp webApp, Servlet servlet) {
        String servletName = servlet.getServletName();
        if (servletName != null) {
            Iterator oldMappings = webApp.getServletMappings().iterator();
            while (oldMappings.hasNext()) {
                ServletMapping mapping = (ServletMapping)oldMappings.next();
                if (!mapping.getServlet().getServletName().equals(servletName)) continue;
                webApp.getServletMappings().remove((Object)mapping);
            }
        }
    }

    public static void setupConfigFileContextParamForV2_3(WebApp webApp, IDataModel config) {
        ContextParam cp = null;
        ContextParam foundCP = null;
        boolean found = false;
        if (!config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH").equals(JSF_DEFAULT_CONFIG_PATH)) {
            Iterator it = webApp.getContexts().iterator();
            while (it.hasNext()) {
                cp = (ContextParam)it.next();
                if (!cp.getParamName().equals(JSF_CONFIG_CONTEXT_PARAM)) continue;
                foundCP = cp;
                found = true;
            }
            if (!found) {
                cp = WebapplicationFactory.eINSTANCE.createContextParam();
                cp.setParamName(JSF_CONFIG_CONTEXT_PARAM);
                cp.setParamValue(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
                webApp.getContexts().add((Object)cp);
            } else {
                cp = foundCP;
                if (cp.getParamValue().indexOf(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) < 0) {
                    String curVal = cp.getParamValue();
                    String val = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
                    if (curVal != null || !curVal.trim().equals("")) {
                        val = String.valueOf(curVal) + ",\n" + val;
                    }
                    cp.setParamValue(val);
                }
            }
        }
    }

    public static void setupConfigFileContextParamForV2_4(WebApp webApp, IDataModel config) {
        ParamValue foundCP = null;
        ParamValue cp = null;
        boolean found = false;
        if (!config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH").equals(JSF_DEFAULT_CONFIG_PATH)) {
            Iterator it = webApp.getContextParams().iterator();
            while (it.hasNext()) {
                cp = (ParamValue)it.next();
                if (!cp.getName().equals(JSF_CONFIG_CONTEXT_PARAM)) continue;
                foundCP = cp;
                found = true;
            }
            if (!found) {
                ParamValue pv = CommonFactory.eINSTANCE.createParamValue();
                pv.setName(JSF_CONFIG_CONTEXT_PARAM);
                pv.setValue(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
                webApp.getContextParams().add((Object)pv);
            } else {
                cp = foundCP;
                if (cp.getValue().indexOf(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) < 0) {
                    String curVal = cp.getValue();
                    String val = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
                    if (curVal != null || !curVal.trim().equals("")) {
                        val = String.valueOf(curVal) + ",\n" + val;
                    }
                    cp.setValue(val);
                }
            }
        }
    }
}

