/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.undo;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.wst.sse.core.internal.undo.CommandCursorPosition;

public class StructuredTextCompoundCommandImpl
extends CompoundCommand
implements CommandCursorPosition {
    protected int fRedoCursorPosition = -1;
    protected int fRedoSelectionLength = 0;
    protected int fUndoCursorPosition = -1;
    protected int fUndoSelectionLength = 0;

    public StructuredTextCompoundCommandImpl() {
    }

    public StructuredTextCompoundCommandImpl(int resultIndex) {
        super(resultIndex);
    }

    public StructuredTextCompoundCommandImpl(int resultIndex, List commandList) {
        super(resultIndex, commandList);
    }

    public StructuredTextCompoundCommandImpl(int resultIndex, String label) {
        super(resultIndex, label);
    }

    public StructuredTextCompoundCommandImpl(int resultIndex, String label, List commandList) {
        super(resultIndex, label, commandList);
    }

    public StructuredTextCompoundCommandImpl(int resultIndex, String label, String description) {
        super(resultIndex, label, description);
    }

    public StructuredTextCompoundCommandImpl(int resultIndex, String label, String description, List commandList) {
        super(resultIndex, label, description, commandList);
    }

    public StructuredTextCompoundCommandImpl(List commandList) {
        super(commandList);
    }

    public StructuredTextCompoundCommandImpl(String label) {
        super(label);
    }

    public StructuredTextCompoundCommandImpl(String label, List commandList) {
        super(label, commandList);
    }

    public StructuredTextCompoundCommandImpl(String label, String description) {
        super(label, description);
    }

    public StructuredTextCompoundCommandImpl(String label, String description, List commandList) {
        super(label, description, commandList);
    }

    public int getRedoCursorPosition() {
        int commandListSize;
        Command lastCommand;
        int cursorPosition = -1;
        if (this.fRedoCursorPosition != -1) {
            cursorPosition = this.fRedoCursorPosition;
        } else if (!this.commandList.isEmpty() && (lastCommand = (Command)this.commandList.get((commandListSize = this.commandList.size()) - 1)) instanceof CommandCursorPosition) {
            cursorPosition = ((CommandCursorPosition)lastCommand).getRedoCursorPosition();
        }
        return cursorPosition;
    }

    public int getRedoSelectionLength() {
        return this.fRedoSelectionLength;
    }

    public int getUndoCursorPosition() {
        Command firstCommand;
        int cursorPosition = -1;
        if (this.fUndoCursorPosition != -1) {
            cursorPosition = this.fUndoCursorPosition;
        } else if (!this.commandList.isEmpty() && (firstCommand = (Command)this.commandList.get(0)) instanceof CommandCursorPosition) {
            cursorPosition = ((CommandCursorPosition)firstCommand).getUndoCursorPosition();
        }
        return cursorPosition;
    }

    public int getUndoSelectionLength() {
        return this.fUndoSelectionLength;
    }

    public void setRedoCursorPosition(int cursorPosition) {
        this.fRedoCursorPosition = cursorPosition;
    }

    public void setRedoSelectionLength(int selectionLength) {
        this.fRedoSelectionLength = selectionLength;
    }

    public void setUndoCursorPosition(int cursorPosition) {
        this.fUndoCursorPosition = cursorPosition;
    }

    public void setUndoSelectionLength(int selectionLength) {
        this.fUndoSelectionLength = selectionLength;
    }
}

